/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.dynamicclassloading;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.jar.JarFile;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.language.IFacet;
import org.metaborg.core.resource.IResourceService;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class DynamicClassLoadingFacet
implements IFacet {
    private static final ILogger logger = LoggerUtils.logger(DynamicClassLoadingFacet.class);
    public final Collection<FileObject> jarFiles;

    public DynamicClassLoadingFacet(Collection<FileObject> jarFiles) {
        this.jarFiles = jarFiles;
    }

    public Collection<String> available(IResourceService resourceService) throws IOException {
        LinkedList<String> errors = new LinkedList<String>();
        for (FileObject file : this.jarFiles) {
            if (!file.exists()) {
                String message = logger.format("JAR file {} does not exist", file);
                errors.add(message);
                continue;
            }
            File localFile = resourceService.localFile(file);
            Throwable throwable = null;
            Object var7_8 = null;
            try (JarFile jarFile = new JarFile(localFile, false, 1);){
                if (jarFile.entries().hasMoreElements()) continue;
                String message = logger.format("JAR file {} is empty", file);
                errors.add(message);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return errors;
    }
}

