/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.dialogs;

import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public interface ISpoofaxDialogService {
    @Nullable
    public DialogOption showDialog(String var1, @Nullable String var2, @Nullable DialogKind var3, @Nullable List<DialogOption> var4, int var5);

    @Nullable
    public String showInputDialog(String var1, @Nullable String var2, @Nullable String var3, @Nullable Function<String, String> var4);

    public static enum DialogKind {
        None,
        Info,
        Warning,
        Error,
        Question;

    }

    public static class DialogOption {
        public static DialogOption OK = new DialogOption("OK");
        public static DialogOption CANCEL = new DialogOption("Cancel");
        public static DialogOption YES = new DialogOption("Yes");
        public static DialogOption NO = new DialogOption("No");
        public static DialogOption RETRY = new DialogOption("Retry");
        public static DialogOption ABORT = new DialogOption("Abort");
        public static DialogOption IGNORE = new DialogOption("Ignore");
        private final String name;

        public DialogOption(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DialogOption)) {
                return false;
            }
            DialogOption that = (DialogOption)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

