/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.action;

import java.util.Collection;
import java.util.LinkedList;
import org.metaborg.core.action.IActionService;
import org.metaborg.core.action.ITransformAction;
import org.metaborg.core.action.ITransformGoal;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.language.FacetContribution;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.spoofax.core.action.ActionFacet;
import org.metaborg.util.iterators.Iterables2;

public class ActionService
implements IActionService {
    public Collection<ITransformAction> actions(ILanguageImpl language, ITransformGoal goal) {
        Iterable<ActionFacet> facets = language.facets(ActionFacet.class);
        LinkedList<ITransformAction> actions = new LinkedList<ITransformAction>();
        for (ActionFacet facet : facets) {
            Iterables2.addAll(actions, facet.actions(goal));
        }
        return actions;
    }

    public Collection<TransformActionContrib> actionContributions(ILanguageImpl language, ITransformGoal goal) {
        Iterable<FacetContribution<ActionFacet>> facetsContributions = language.facetContributions(ActionFacet.class);
        LinkedList<TransformActionContrib> actionContributions = new LinkedList<TransformActionContrib>();
        for (FacetContribution<ActionFacet> facetContribution : facetsContributions) {
            ActionFacet facet = (ActionFacet)facetContribution.facet;
            ILanguageComponent component = facetContribution.contributor;
            for (ITransformAction action : facet.actions(goal)) {
                actionContributions.add(new TransformActionContrib(action, component));
            }
        }
        return actionContributions;
    }

    @Override
    public boolean available(ILanguageImpl language, ITransformGoal goal) {
        return !this.actions(language, goal).isEmpty();
    }

    @Override
    public boolean requiresAnalysis(ILanguageImpl language, ITransformGoal goal) {
        for (ITransformAction action : this.actions(language, goal)) {
            if (action.flags().parsed) continue;
            return true;
        }
        return false;
    }
}

