/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.parsetable;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.metaborg.sdf2table.deepconflicts.ContextualProduction;
import org.metaborg.sdf2table.deepconflicts.ContextualSymbol;
import org.metaborg.sdf2table.grammar.IProduction;
import org.metaborg.sdf2table.grammar.Priority;
import org.metaborg.sdf2table.grammar.Production;
import org.metaborg.sdf2table.grammar.Symbol;
import org.metaborg.sdf2table.parsetable.ParseTable;
import org.metaborg.sdf2table.parsetable.State;
import org.metaborg.util.collection.LinkedSetMultimap;

public class LRItem
implements Serializable {
    private static final long serialVersionUID = 6331111365917952694L;
    private ParseTable pt;
    private IProduction prod;
    private int dotPosition;
    private int prod_label;

    public LRItem(IProduction prod, int dotPosition, ParseTable pt) {
        this.prod = !(prod instanceof ContextualProduction) && pt.normalizedGrammar().getProdContextualProdMapping().containsKey(prod) ? (IProduction)pt.normalizedGrammar().getProdContextualProdMapping().get(prod) : prod;
        this.pt = pt;
        this.dotPosition = dotPosition;
        this.prod_label = pt.productionLabels().get(prod);
    }

    public void process(Set<LRItem> items, LinkedSetMultimap<Symbol, LRItem> symbol_items, State originalState) {
        items.add(this);
        if (this.pt.cachedItems().containsKey(this)) {
            for (LRItem item : this.pt.cachedItems().get(this)) {
                if (!items.contains(item)) {
                    item.process(items, symbol_items, originalState);
                }
                items.add(item);
            }
        } else {
            items.add(this);
            HashSet<LRItem> derivedItems = new HashSet<LRItem>();
            if (this.dotPosition < this.prod.arity()) {
                Symbol s_at_dot = (Symbol)this.prod.rightHand().get(this.dotPosition);
                for (IProduction p : (Set)this.pt.normalizedGrammar().getSymbolProductionsMapping().get(s_at_dot)) {
                    if (this.isPriorityConflict(p)) continue;
                    if (this.pt.normalizedGrammar().getProdContextualProdMapping().get(p) != null) {
                        p = this.pt.normalizedGrammar().getProdContextualProdMapping().get(p);
                    }
                    LRItem newItem = new LRItem(p, 0, this.pt);
                    derivedItems.add(newItem);
                    if (items.contains(newItem)) continue;
                    newItem.process(items, symbol_items, originalState);
                }
            }
            this.pt.cachedItems().put(this, derivedItems);
        }
        if (this.dotPosition < this.prod.arity()) {
            Symbol atPosition = (Symbol)this.prod.rightHand().get(this.dotPosition);
            if (this.pt.getConfig().isDataDependent() && atPosition instanceof ContextualSymbol) {
                atPosition = ((ContextualSymbol)atPosition).getOrigSymbol();
            }
            symbol_items.put(atPosition, this);
            this.pt.getSymbolStatesMapping().addLink(atPosition, this, originalState);
        }
    }

    public LRItem shiftDot() {
        return new LRItem(this.prod, this.dotPosition + 1, this.pt);
    }

    public IProduction getProd() {
        return this.prod;
    }

    public int getDotPosition() {
        return this.dotPosition;
    }

    public String toString() {
        String buf = "";
        buf = String.valueOf(buf) + this.prod.leftHand();
        buf = String.valueOf(buf) + " -> ";
        int i = 0;
        while (i < this.prod.arity()) {
            if (i != 0) {
                buf = String.valueOf(buf) + " ";
            }
            if (i == this.dotPosition) {
                buf = String.valueOf(buf) + ". ";
            }
            buf = String.valueOf(buf) + this.prod.rightHand().get(i);
            ++i;
        }
        if (this.dotPosition >= this.prod.arity()) {
            buf = String.valueOf(buf) + " .";
        }
        return buf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dotPosition;
        result = 31 * result + this.prod_label;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LRItem other = (LRItem)obj;
        return this.dotPosition == other.dotPosition && this.prod_label == other.prod_label;
    }

    public boolean isPriorityConflict(IProduction p) {
        IProduction higher = this.prod;
        Production lower = p instanceof ContextualProduction ? ((ContextualProduction)p).getOrigProduction() : (Production)p;
        if (higher instanceof ContextualProduction) {
            higher = ((ContextualProduction)higher).getOrigProduction();
        }
        Priority prio = this.pt.normalizedGrammar().getGrammarFactory().createPriority((Production)higher, lower, false);
        return ((Set)this.pt.normalizedGrammar().priorities().get(prio)).contains(this.dotPosition) || ((Set)this.pt.normalizedGrammar().getIndexedPriorities().get(prio)).contains(this.dotPosition);
    }
}

