/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.evaluation;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.util.Debug;
import org.metaborg.util.collection.BiSetMultimap;
import org.metaborg.util.iterators.Iterables2;
import org.spoofax.interpreter.terms.IStrategoTerm;

public final class TaskEvaluationDebugging {
    public static void debugUnevaluated(ITaskEngine taskEngine, Iterable<IStrategoTerm> unevaluated, BiSetMultimap<IStrategoTerm, IStrategoTerm> toRuntimeDependency) {
        if (Debug.DEBUGGING) {
            ITask task;
            Set<IStrategoTerm> cycle = TaskEvaluationDebugging.findCycle(toRuntimeDependency, unevaluated);
            if (cycle != null) {
                System.err.println("Cycle found: " + cycle);
                for (IStrategoTerm taskID : cycle) {
                    task = taskEngine.getTask(taskID);
                    System.err.println("\t" + taskID + ": " + task + " - " + toRuntimeDependency.get(taskID));
                }
                System.err.println();
            }
            for (IStrategoTerm taskID : unevaluated) {
                task = taskEngine.getTask(taskID);
                Set dependencies = toRuntimeDependency.get(taskID);
                if (!dependencies.isEmpty()) {
                    System.err.println(taskID + ": " + task + " still depends on: ");
                }
                for (IStrategoTerm dependencyID : dependencies) {
                    ITask dependency = taskEngine.getTask(dependencyID);
                    if (dependency.solved()) continue;
                    System.err.println("\t" + dependencyID + ": " + dependency);
                }
            }
            System.err.println();
            System.err.println();
        }
    }

    private static Set<IStrategoTerm> findCycle(BiSetMultimap<IStrategoTerm, IStrategoTerm> toRuntimeDependency, Iterable<IStrategoTerm> tasks) {
        return TaskEvaluationDebugging.findCycle(toRuntimeDependency, tasks, new LinkedHashSet<IStrategoTerm>());
    }

    private static Set<IStrategoTerm> findCycle(BiSetMultimap<IStrategoTerm, IStrategoTerm> toRuntimeDependency, Iterable<IStrategoTerm> tasks, Set<IStrategoTerm> seen) {
        Iterator<IStrategoTerm> iterator = tasks.iterator();
        while (iterator.hasNext()) {
            LinkedHashSet<IStrategoTerm> newSeen = new LinkedHashSet<IStrategoTerm>(seen);
            IStrategoTerm taskID = iterator.next();
            if (!newSeen.add(taskID)) {
                return newSeen;
            }
            Set<IStrategoTerm> rec = TaskEvaluationDebugging.findCycle(toRuntimeDependency, toRuntimeDependency.get(taskID), newSeen);
            if (rec == null) continue;
            return rec;
        }
        return null;
    }

    public static void debugDelayedDependecy(ITaskEngine taskEngine, IStrategoTerm taskID, Iterable<IStrategoTerm> dependencies) {
        if (Debug.DEBUGGING) {
            ITask task = taskEngine.getTask(taskID);
            if (Iterables2.isEmpty(dependencies)) {
                System.err.println("Task " + taskID + ": " + task + " reported a dynamic dependency on nothing.");
            }
            for (IStrategoTerm dependencyID : dependencies) {
                ITask dependencyTask = taskEngine.getTask(dependencyID);
                if (!dependencyTask.solved()) continue;
                System.err.println("Task " + taskID + ": " + task + " reported a dynamic dependency on " + dependencyID + ": " + dependencyTask + " but it is already solved!");
            }
        }
    }
}

