/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.runtime.task.engine;

import java.util.Map;
import java.util.Set;
import org.metaborg.runtime.task.ITask;
import org.metaborg.runtime.task.TaskStatus;
import org.metaborg.runtime.task.TaskStorageType;
import org.metaborg.runtime.task.TaskType;
import org.metaborg.runtime.task.engine.ITaskEngine;
import org.metaborg.runtime.task.util.TermTools;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.attachments.TermAttachmentSerializer;

public class TaskEngineFactory {
    public IStrategoTerm toTerm(ITaskEngine taskEngine, ITermFactory factory) {
        TermAttachmentSerializer serializer = new TermAttachmentSerializer(factory);
        IStrategoTerm digestState = taskEngine.getDigester().state(factory);
        IStrategoList tasks = factory.makeList();
        for (Map.Entry<IStrategoTerm, ITask> entry : taskEngine.getTaskEntries()) {
            IStrategoTerm taskID = entry.getKey();
            ITask task = entry.getValue();
            IStrategoTerm results = serializer.toAnnotations(TermTools.makeList(factory, task.results()));
            IStrategoTerm message = task.message();
            if (message != null) {
                message = serializer.toAnnotations(message);
            }
            Set<IStrategoTerm> sources = taskEngine.getSourcesOf(taskID);
            Iterable<IStrategoTerm> dependencies = taskEngine.getDependencies(taskID, false);
            Iterable<IStrategoTerm> dynamicDependencies = taskEngine.getDynamicDependencies(taskID);
            Iterable<IStrategoTerm> reads = taskEngine.getReads(taskID);
            IStrategoTuple taskTuple = factory.makeTuple(taskID, task.initialInstruction(), task.initialDependencies(), factory.makeInt(task.type().id), factory.makeInt(task.storageType().id), factory.makeInt(task.actualStorageType().id), TermTools.makeBool(factory, task.shortCircuit()), TermTools.makeNullable(factory, task.instructionOverride()), results, factory.makeInt(task.status().id), TermTools.makeNullable(factory, message), TermTools.makeLong(factory, task.time()), TermTools.makeShort(factory, task.evaluations()), TermTools.makeList(factory, sources), TermTools.makeList(factory, dependencies), TermTools.makeList(factory, dynamicDependencies), TermTools.makeList(factory, reads));
            tasks = factory.makeListCons(taskTuple, tasks);
        }
        return factory.makeTuple(digestState, tasks);
    }

    public ITaskEngine fromTerms(ITaskEngine taskEngine, IStrategoTerm term, ITermFactory factory) {
        TermAttachmentSerializer serializer = new TermAttachmentSerializer(factory);
        IStrategoTerm digestState = term.getSubterm(0);
        taskEngine.getDigester().setState(digestState);
        IStrategoTerm tasks = term.getSubterm(1);
        for (IStrategoTerm taskTerm : tasks) {
            int i = -1;
            IStrategoTerm taskID = taskTerm.getSubterm(++i);
            IStrategoAppl instruction = (IStrategoAppl)taskTerm.getSubterm(++i);
            IStrategoList initialDependencies = (IStrategoList)taskTerm.getSubterm(++i);
            IStrategoInt type = (IStrategoInt)taskTerm.getSubterm(++i);
            IStrategoInt storageType = (IStrategoInt)taskTerm.getSubterm(++i);
            IStrategoInt actualStorageType = (IStrategoInt)taskTerm.getSubterm(++i);
            IStrategoInt shortCircuit = (IStrategoInt)taskTerm.getSubterm(++i);
            IStrategoTerm instructionOverride = taskTerm.getSubterm(++i);
            IStrategoTerm results = serializer.fromAnnotations(taskTerm.getSubterm(++i), false);
            IStrategoInt status = (IStrategoInt)taskTerm.getSubterm(++i);
            IStrategoTerm message = serializer.fromAnnotations(taskTerm.getSubterm(++i), false);
            IStrategoTerm time = taskTerm.getSubterm(++i);
            IStrategoTerm evaluations = taskTerm.getSubterm(++i);
            IStrategoList sources = (IStrategoList)taskTerm.getSubterm(++i);
            IStrategoList dependencies = (IStrategoList)taskTerm.getSubterm(++i);
            IStrategoList dynamicDependencies = (IStrategoList)taskTerm.getSubterm(++i);
            IStrategoList reads = (IStrategoList)taskTerm.getSubterm(++i);
            ITask task = taskEngine.getTaskFactory(instruction).create(instruction, initialDependencies, TaskType.get(type.intValue()), TaskStorageType.get(storageType.intValue()), TaskStorageType.get(actualStorageType.intValue()), TermTools.takeBool(shortCircuit));
            if (!TermTools.isNull(instructionOverride)) {
                task.overrideInstruction((IStrategoAppl)instructionOverride);
            }
            if (!TermTools.isNull(results)) {
                task.results().set(results);
            }
            task.setStatus(TaskStatus.get(status.intValue()));
            if (!TermTools.isNull(message)) {
                task.setMessage(message);
            }
            task.setTime(TermTools.takeLong(time));
            task.setEvaluations(TermTools.takeShort(evaluations));
            taskEngine.addPersistedTask(taskID, task, initialDependencies);
            for (IStrategoTerm source : sources) {
                taskEngine.addToSource(taskID, source);
            }
            for (IStrategoTerm dependency : dependencies) {
                taskEngine.addDependency(taskID, dependency);
            }
            taskEngine.setDynamicDependencies(taskID, dynamicDependencies);
            for (IStrategoTerm read : reads) {
                taskEngine.addRead(taskID, read);
            }
        }
        return taskEngine;
    }
}

