/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.processing.parse;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.build.UpdateKind;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.processing.parse.IParseResultProcessor;
import org.metaborg.core.processing.parse.ParseChange;
import org.metaborg.core.syntax.IInputUnit;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.syntax.ISyntaxService;
import org.metaborg.core.syntax.ParseException;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ParseResultProcessor<I extends IInputUnit, P extends IParseUnit>
implements IParseResultProcessor<I, P>,
AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(ParseResultProcessor.class);
    private final ISyntaxService<I, P> syntaxService;
    private final ConcurrentMap<FileName, BehaviorSubject<ParseChange<P>>> updatesPerResource = new ConcurrentHashMap<FileName, BehaviorSubject<ParseChange<P>>>();

    @Inject
    public ParseResultProcessor(ISyntaxService<I, P> syntaxService) {
        this.syntaxService = syntaxService;
    }

    @Override
    public void close() {
        for (BehaviorSubject updates : this.updatesPerResource.values()) {
            updates.onComplete();
        }
        this.updatesPerResource.clear();
    }

    @Override
    public Observable<P> request(I input) {
        FileObject resource = input.source();
        return Observable.create(observer -> {
            if (observer.isDisposed()) {
                logger.trace("Unsubscribed from parse result request for {}", input);
                return;
            }
            BehaviorSubject<ParseChange<P>> updates = this.getUpdates(input);
            ParseChange update = updates.blockingStream().filter(updateToFilter -> {
                UpdateKind kind = updateToFilter.kind;
                return kind != UpdateKind.Invalidate;
            }).findFirst().orElse(null);
            if (update == null) {
                return;
            }
            if (observer.isDisposed()) {
                logger.trace("Unsubscribed from parse result request for {}", resource);
                return;
            }
            switch (update.kind) {
                case Update: {
                    logger.trace("Returning cached parse result for {}", resource);
                    observer.onNext(update.unit);
                    observer.onComplete();
                    break;
                }
                case Error: {
                    logger.trace("Returning parse error for {}", resource);
                    observer.onError((Throwable)update.exception);
                    break;
                }
                case Remove: {
                    String message = logger.format("Parse result for {} was removed unexpectedly", resource);
                    logger.error(message);
                    observer.onError((Throwable)new ParseException((IInputUnit)input, message));
                    break;
                }
                default: {
                    String message = logger.format("Unexpected parse update kind {} for {}", new Object[]{update.kind, resource});
                    logger.error(message);
                    observer.onError((Throwable)new ParseException((IInputUnit)input, message));
                }
            }
        });
    }

    @Override
    public Observable<ParseChange<P>> updates(FileObject resource) {
        return this.getUpdates((I)resource.getName());
    }

    @Override
    @Nullable
    public P get(FileObject resource) {
        BehaviorSubject subject = (BehaviorSubject)this.updatesPerResource.get(resource.getName());
        if (subject == null) {
            return null;
        }
        ParseChange change = subject.blockingStream().findFirst().orElse(null);
        if (change == null) {
            return null;
        }
        return change.unit;
    }

    @Override
    public void invalidate(FileObject resource) {
        logger.trace("Invalidating parse result for {}", resource);
        BehaviorSubject<ParseChange<P>> updates = this.getUpdates((I)resource.getName());
        updates.onNext(ParseChange.invalidate(resource));
    }

    @Override
    public void invalidate(ILanguageImpl impl) {
        for (BehaviorSubject changes : this.updatesPerResource.values()) {
            ParseChange change = changes.blockingStream().findFirst().orElse(null);
            if (change == null || change.unit == null || !impl.equals(change.unit.input().langImpl())) continue;
            changes.onNext(ParseChange.invalidate(change.resource));
        }
    }

    @Override
    public void update(FileObject resource, P unit) {
        logger.trace("Pushing parse result for {}", resource);
        BehaviorSubject<ParseChange<P>> updates = this.getUpdates((I)resource.getName());
        updates.onNext(ParseChange.update(unit));
    }

    @Override
    public void error(FileObject resource, ParseException exception) {
        logger.trace("Pushing parse error for {}", resource);
        BehaviorSubject<ParseChange<P>> updates = this.getUpdates((I)resource.getName());
        updates.onNext(ParseChange.error(exception));
    }

    @Override
    public void remove(FileObject resource) {
        logger.trace("Removing parse result for {}", resource);
        BehaviorSubject<ParseChange<P>> updates = this.getUpdates((I)resource.getName());
        updates.onNext(ParseChange.remove(resource));
    }

    private BehaviorSubject<ParseChange<P>> getUpdates(FileName file) {
        BehaviorSubject newUpdates = BehaviorSubject.create();
        BehaviorSubject prevUpdates = this.updatesPerResource.putIfAbsent(file, newUpdates);
        return prevUpdates == null ? newUpdates : prevUpdates;
    }

    private BehaviorSubject<ParseChange<P>> getUpdates(I unit) {
        FileObject resource = unit.source();
        FileName name = resource.getName();
        BehaviorSubject updates = (BehaviorSubject)this.updatesPerResource.get(name);
        if (updates == null) {
            updates = BehaviorSubject.create();
            this.updatesPerResource.put(name, updates);
            try {
                logger.trace("Parsing for {}", resource);
                P result = this.syntaxService.parse(unit);
                updates.onNext(ParseChange.update(result));
            }
            catch (ParseException e) {
                String message = String.format("Parsing for %s failed", name);
                logger.error(message, e);
                updates.onNext(ParseChange.error(e));
            }
        }
        return updates;
    }
}

