/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.menu;

import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.LinkedList;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.action.IAction;
import org.metaborg.core.action.ITransformAction;
import org.metaborg.core.menu.IMenu;
import org.metaborg.core.menu.IMenuAction;
import org.metaborg.core.menu.IMenuItem;
import org.metaborg.core.menu.IMenuItemVisitor;
import org.metaborg.util.Strings;
import org.metaborg.util.iterators.Iterables2;

public class Menu
implements IMenu {
    private final String name;
    private final Collection<IMenuItem> items;

    public Menu(String name) {
        this(name, new LinkedList<IMenuItem>());
    }

    public Menu(String name, Collection<IMenuItem> items) {
        this.name = name;
        this.items = items;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Iterable<IMenuItem> items() {
        return this.items;
    }

    @Override
    @Nullable
    public IAction action(String name) throws MetaborgException {
        LinkedList<ITransformAction> actions = new LinkedList<ITransformAction>();
        for (IMenuItem item : this.items) {
            if (!(item instanceof IMenuAction) || !name.equals(item.name())) continue;
            IMenuAction menuAction = (IMenuAction)item;
            ITransformAction action = menuAction.action();
            actions.add(action);
        }
        int size = actions.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            String message = String.format("Found multiple actions with name %s: %s", name, Strings.tsJoin(actions, ", "));
            throw new MetaborgException(message);
        }
        return (IAction)actions.get(0);
    }

    public void add(IMenuItem item) {
        this.items.add(item);
    }

    public void add(Iterable<? extends IMenuItem> items) {
        Iterables2.addAll(this.items, items);
    }

    @Override
    public void accept(IMenuItemVisitor visitor) {
        visitor.visitMenu(this);
    }
}

