/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.metaborg.core.language.ILanguageIdentifierService;
import org.metaborg.core.language.ILanguageImpl;

public class LanguagesFileSelector
implements FileSelector {
    private final ILanguageIdentifierService languageIdentifierService;
    private final Iterable<ILanguageImpl> languages;

    public LanguagesFileSelector(ILanguageIdentifierService languageIdentifierService, Iterable<ILanguageImpl> languages) {
        this.languageIdentifierService = languageIdentifierService;
        this.languages = languages;
    }

    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
        FileObject file = fileInfo.getFile();
        return FileType.FILE.equals((Object)file.getType()) && this.languageIdentifierService.identify(file, this.languages) != null;
    }

    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
        return true;
    }
}

