/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import jakarta.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.language.ComponentCreationConfig;
import org.metaborg.core.language.ILanguage;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageComponentInternal;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.ILanguageImplInternal;
import org.metaborg.core.language.ILanguageInternal;
import org.metaborg.core.language.ILanguageService;
import org.metaborg.core.language.Language;
import org.metaborg.core.language.LanguageComponent;
import org.metaborg.core.language.LanguageComponentChange;
import org.metaborg.core.language.LanguageContributionIdentifier;
import org.metaborg.core.language.LanguageIdentifier;
import org.metaborg.core.language.LanguageImplChange;
import org.metaborg.core.language.LanguageImplementation;
import org.metaborg.util.collection.Sets;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class LanguageService
implements ILanguageService,
AutoCloseable {
    private static final ILogger logger = LoggerUtils.logger(LanguageService.class);
    private final AtomicInteger sequenceIdGenerator = new AtomicInteger(0);
    private final Map<FileName, ILanguageComponentInternal> locationToComponent = new HashMap<FileName, ILanguageComponentInternal>();
    private final Map<LanguageIdentifier, ILanguageComponentInternal> identifierToComponent = new HashMap<LanguageIdentifier, ILanguageComponentInternal>();
    private final Subject<LanguageComponentChange> componentChanges = PublishSubject.create();
    private final Map<LanguageIdentifier, ILanguageImplInternal> identifierToImpl = new HashMap<LanguageIdentifier, ILanguageImplInternal>();
    private final Map<String, Set<ILanguageImplInternal>> idToImpl = new HashMap<String, Set<ILanguageImplInternal>>();
    private final Subject<LanguageImplChange> implChanges = PublishSubject.create();
    private final Map<String, ILanguageInternal> nameToLanguage = new HashMap<String, ILanguageInternal>();
    private final ConcurrentMap<String, WeakReference<ILanguageInternal>> languageCache = new ConcurrentHashMap<String, WeakReference<ILanguageInternal>>();
    private final ConcurrentMap<LanguageIdentifier, WeakReference<ILanguageImplInternal>> languageImplCache = new ConcurrentHashMap<LanguageIdentifier, WeakReference<ILanguageImplInternal>>();

    @Override
    public void close() {
        this.languageImplCache.clear();
        this.languageCache.clear();
        this.nameToLanguage.clear();
        this.implChanges.onComplete();
        this.idToImpl.clear();
        this.identifierToImpl.clear();
        this.componentChanges.onComplete();
        this.identifierToComponent.clear();
        this.locationToComponent.clear();
    }

    @Override
    @Nullable
    public ILanguageComponent getComponent(LanguageIdentifier identifier) {
        return this.identifierToComponent.get(identifier);
    }

    @Override
    public ILanguageComponent getComponent(FileName location) {
        return this.locationToComponent.get(location);
    }

    @Override
    @Nullable
    public ILanguageImpl getImpl(LanguageIdentifier identifier) {
        return this.identifierToImpl.get(identifier);
    }

    @Override
    @Nullable
    public ILanguage getLanguage(String name) {
        return this.nameToLanguage.get(name);
    }

    @Override
    public Iterable<? extends ILanguageComponent> getAllComponents() {
        return this.identifierToComponent.values();
    }

    @Override
    public Iterable<? extends ILanguageImpl> getAllImpls() {
        return this.identifierToImpl.values();
    }

    @Override
    public Iterable<? extends ILanguageImpl> getAllImpls(String groupId, String id) {
        return this.idToImpl.getOrDefault(this.groupIdId(groupId, id), Collections.emptySet());
    }

    @Override
    public Iterable<? extends ILanguage> getAllLanguages() {
        return this.nameToLanguage.values();
    }

    @Override
    public Observable<LanguageComponentChange> componentChanges() {
        return this.componentChanges;
    }

    @Override
    public Observable<LanguageImplChange> implChanges() {
        return this.implChanges;
    }

    @Override
    public ILanguageComponent add(ComponentCreationConfig config) {
        this.validateLocation(config.location);
        LinkedList<ILanguageImplInternal> impls = new LinkedList<ILanguageImplInternal>();
        for (LanguageContributionIdentifier identifier : config.implIds) {
            ILanguageInternal language = this.getOrCreateLanguage(identifier.name);
            ILanguageImplInternal iLanguageImplInternal = this.getOrCreateLanguageImpl(identifier.id, language);
            impls.add(iLanguageImplInternal);
        }
        ILanguageComponentInternal existingComponent = this.identifierToComponent.get(config.identifier);
        LanguageComponent newComponent = new LanguageComponent(config.identifier, config.location, this.sequenceIdGenerator.getAndIncrement(), impls, config.config, config.facets);
        if (existingComponent == null) {
            this.addComponent(newComponent);
            LinkedList<ILanguageImplInternal> changedImpls = new LinkedList<ILanguageImplInternal>();
            for (ILanguageImplInternal iLanguageImplInternal : impls) {
                if (!iLanguageImplInternal.addComponent(newComponent)) continue;
                changedImpls.add(iLanguageImplInternal);
            }
            this.componentChange(LanguageComponentChange.Kind.Add, null, newComponent);
            for (ILanguageImplInternal iLanguageImplInternal : changedImpls) {
                if (Iterables2.size(iLanguageImplInternal.components()) == 1) {
                    this.implChange(LanguageImplChange.Kind.Add, iLanguageImplInternal);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, iLanguageImplInternal);
            }
        } else {
            this.removeComponent(existingComponent);
            HashSet<ILanguageImplInternal> removedFromImpls = new HashSet<ILanguageImplInternal>();
            for (ILanguageImplInternal iLanguageImplInternal : existingComponent.contributesToInternal()) {
                if (!iLanguageImplInternal.removeComponent(existingComponent)) continue;
                removedFromImpls.add(iLanguageImplInternal);
            }
            existingComponent.clearContributions();
            this.addComponent(newComponent);
            HashSet<ILanguageImplInternal> hashSet = new HashSet<ILanguageImplInternal>();
            for (ILanguageImplInternal impl : impls) {
                if (!impl.addComponent(newComponent)) continue;
                hashSet.add(impl);
            }
            this.componentChange(LanguageComponentChange.Kind.Reload, existingComponent, newComponent);
            Set<ILanguageImplInternal> removed = Sets.difference(removedFromImpls, hashSet);
            for (ILanguageImplInternal impl : removed) {
                if (Iterables2.isEmpty(impl.components())) {
                    this.removeImplementation(impl);
                    ILanguageInternal language = impl.belongsToInternal();
                    language.remove(impl);
                    this.implChange(LanguageImplChange.Kind.Remove, impl);
                    if (!Iterables2.isEmpty(language.impls())) continue;
                    this.removeLanguage(language);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
            Set<ILanguageImplInternal> keep = Sets.intersection(removedFromImpls, hashSet);
            for (ILanguageImplInternal impl : keep) {
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
            Set<ILanguageImplInternal> added = Sets.difference(hashSet, removedFromImpls);
            for (ILanguageImplInternal impl : added) {
                if (Iterables2.size(impl.components()) == 1) {
                    this.implChange(LanguageImplChange.Kind.Add, impl);
                    continue;
                }
                this.implChange(LanguageImplChange.Kind.Reload, impl);
            }
        }
        return newComponent;
    }

    private ILanguageInternal getOrCreateLanguage(String languageName) {
        ILanguageInternal language = this.nameToLanguage.get(languageName);
        if (language == null) {
            language = this.getCached(this.languageCache, languageName, ln -> new Language((String)ln));
            this.addLanguage(language);
        }
        assert (language != null);
        return language;
    }

    private ILanguageImplInternal getOrCreateLanguageImpl(LanguageIdentifier identifier, ILanguageInternal language) {
        ILanguageImplInternal impl = this.identifierToImpl.get(identifier);
        if (impl == null) {
            impl = this.getCached(this.languageImplCache, identifier, id -> new LanguageImplementation((LanguageIdentifier)id, language));
            this.addImplementation(impl);
            language.add(impl);
        } else {
            ILanguageInternal prevLanguage = impl.belongsToInternal();
            if (!prevLanguage.equals(language)) {
                throw new IllegalStateException("Contributions of " + identifier + " use conflicting " + prevLanguage + " and " + language);
            }
        }
        assert (impl != null);
        return impl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <K, V> V getCached(ConcurrentMap<K, WeakReference<V>> cache, K languageName, Function<K, V> loader) {
        Object language;
        WeakReference<V> v = (WeakReference<V>)cache.get(languageName);
        if (v == null) {
            language = loader.apply(languageName);
            v = cache.putIfAbsent(languageName, new WeakReference<V>(language));
            if (v == null) return language;
            Object v1 = v.get();
            if (v1 == null) return (V)this.getCached(cache, languageName, loader);
            language = v1;
            return language;
        } else {
            if (v.get() == null) {
                language = loader.apply(languageName);
                boolean replaced = cache.replace(languageName, v, new WeakReference<V>(language));
                if (replaced) return language;
                return (V)this.getCached(cache, languageName, loader);
            }
            language = v.get();
        }
        return language;
    }

    @Override
    public void remove(ILanguageComponent component) {
        ILanguageComponentInternal existingComponent = this.identifierToComponent.get(component.id());
        if (existingComponent == null) {
            throw new IllegalStateException("Cannot remove component " + component + ", it was not added before");
        }
        this.removeComponent(existingComponent);
        HashSet<ILanguageImplInternal> removedFromImpls = new HashSet<ILanguageImplInternal>();
        for (ILanguageImplInternal iLanguageImplInternal : existingComponent.contributesToInternal()) {
            if (!iLanguageImplInternal.removeComponent(existingComponent)) continue;
            removedFromImpls.add(iLanguageImplInternal);
        }
        existingComponent.clearContributions();
        this.componentChange(LanguageComponentChange.Kind.Remove, existingComponent, null);
        for (ILanguageImplInternal iLanguageImplInternal : removedFromImpls) {
            if (Iterables2.isEmpty(iLanguageImplInternal.components())) {
                this.removeImplementation(iLanguageImplInternal);
                ILanguageInternal language = iLanguageImplInternal.belongsToInternal();
                language.remove(iLanguageImplInternal);
                this.implChange(LanguageImplChange.Kind.Remove, iLanguageImplInternal);
                if (!Iterables2.isEmpty(language.impls())) continue;
                this.removeLanguage(language);
                continue;
            }
            this.implChange(LanguageImplChange.Kind.Reload, iLanguageImplInternal);
        }
    }

    private void validateLocation(FileObject location) {
        try {
            if (!location.exists()) {
                throw new IllegalStateException("Cannot add language component at location " + location + ", location does not exist");
            }
        }
        catch (FileSystemException e) {
            throw new IllegalStateException("Cannot add language component at location " + location, e);
        }
    }

    private void addComponent(ILanguageComponentInternal component) {
        this.identifierToComponent.put(component.id(), component);
        this.locationToComponent.put(component.location().getName(), component);
        logger.debug("Adding {}", component);
    }

    private void addImplementation(ILanguageImplInternal impl) {
        LanguageIdentifier id = impl.id();
        this.identifierToImpl.put(id, impl);
        this.idToImpl.computeIfAbsent(this.groupIdId(id), k -> new HashSet()).add(impl);
        logger.debug("Adding {}", impl);
    }

    private void addLanguage(ILanguageInternal language) {
        String name = language.name();
        this.nameToLanguage.put(name, language);
        logger.debug("Adding {}", language);
    }

    private void removeComponent(ILanguageComponentInternal component) {
        this.identifierToComponent.remove(component.id());
        this.locationToComponent.remove(component.location().getName());
        logger.debug("Removing {}", component);
    }

    private void removeImplementation(ILanguageImplInternal impl) {
        LanguageIdentifier id = impl.id();
        this.identifierToImpl.remove(id);
        this.idToImpl.computeIfPresent(this.groupIdId(id), (k, v) -> {
            v.remove(impl);
            return v.isEmpty() ? null : v;
        });
        logger.debug("Removing {}", impl);
    }

    private void removeLanguage(ILanguageInternal language) {
        String name = language.name();
        this.nameToLanguage.remove(name);
        logger.debug("Removing {}", language);
    }

    private String groupIdId(String groupId, String id) {
        return String.valueOf(groupId) + ":" + id;
    }

    private String groupIdId(LanguageIdentifier identifier) {
        return this.groupIdId(identifier.groupId, identifier.id);
    }

    private void componentChange(LanguageComponentChange.Kind kind, ILanguageComponent oldComponent, ILanguageComponent newComponent) {
        this.componentChanges.onNext((Object)new LanguageComponentChange(kind, oldComponent, newComponent));
    }

    private void implChange(LanguageImplChange.Kind kind, ILanguageImpl impl) {
        this.implChanges.onNext((Object)new LanguageImplChange(kind, impl));
    }
}

