/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.language;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metaborg.core.config.LanguageIdentifierDeserializer;
import org.metaborg.core.config.LanguageIdentifierSerializer;
import org.metaborg.core.language.LanguageVersion;
import org.metaborg.util.order.ChainedComparison;

@JsonSerialize(using=LanguageIdentifierSerializer.class)
@JsonDeserialize(using=LanguageIdentifierDeserializer.class)
public class LanguageIdentifier
implements Comparable<LanguageIdentifier>,
Serializable {
    private static final long serialVersionUID = 8892997161544718124L;
    private static final Pattern idPattern = Pattern.compile("[A-Za-z0-9._\\-]+");
    public static final String errorDescription = "may only consist of alphanumeral and _ - . characters";
    private static final Pattern partialPattern = Pattern.compile("(?:(" + idPattern + "):)?(" + idPattern + ")(?::(.+))?");
    private static final Pattern fullPattern = Pattern.compile("(?:(" + idPattern + "):)(" + idPattern + ")(?::(.+))");
    public final String groupId;
    public final String id;
    public final LanguageVersion version;

    public LanguageIdentifier(String groupId, String id, LanguageVersion version) {
        this.groupId = groupId;
        this.id = id;
        this.version = version;
    }

    public LanguageIdentifier(LanguageIdentifier identifier, LanguageVersion version) {
        this(identifier.groupId, identifier.id, version);
    }

    public boolean valid() {
        return LanguageIdentifier.validId(this.groupId) && LanguageIdentifier.validId(this.id);
    }

    public static boolean valid(String identifier) {
        Matcher matcher = partialPattern.matcher(identifier);
        return matcher.matches();
    }

    public static LanguageIdentifier parse(String identifier) {
        return LanguageIdentifier.parse(identifier, partialPattern);
    }

    public static LanguageIdentifier parseFull(String identifier) {
        return LanguageIdentifier.parse(identifier, fullPattern);
    }

    private static LanguageIdentifier parse(String identifier, Pattern pattern) {
        Matcher matcher = pattern.matcher(identifier);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid language identifier " + identifier + ", expected groupId:id:version where characters " + errorDescription);
        }
        String groupId = matcher.group(1);
        if (groupId == null || groupId.isEmpty()) {
            groupId = "org.metaborg";
        }
        String id = matcher.group(2);
        String versionString = matcher.group(3);
        LanguageVersion version = LanguageVersion.parse(versionString);
        return new LanguageIdentifier(groupId, id, version);
    }

    public static boolean validId(String id) {
        Matcher matcher = idPattern.matcher(id);
        return matcher.matches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageIdentifier other = (LanguageIdentifier)obj;
        if (!this.groupId.equals(other.groupId)) {
            return false;
        }
        if (!this.id.equals(other.id)) {
            return false;
        }
        return this.version.equals(other.version);
    }

    @Override
    public int compareTo(LanguageIdentifier other) {
        return new ChainedComparison().compare(this.groupId, other.groupId).compare(this.id, other.id).compare(this.version, other.version).result();
    }

    public String toString() {
        return String.valueOf(this.groupId) + ":" + this.id + ":" + this.version;
    }

    public String toFileString() {
        return String.valueOf(this.id) + "-" + this.version;
    }

    public String toFullFileString() {
        return String.valueOf(this.groupId) + "-" + this.id + "-" + this.version;
    }
}

