/*
 * Decompiled with CFR 0.152.
 */
package mb.util.vfs2.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeSelector;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class ResourceUtils {
    private static final ILogger logger = LoggerUtils.logger(ResourceUtils.class);

    public static FileObject[] expand(FileObject location) {
        try {
            if (location.exists()) {
                FileObject[] files = location.findFiles((FileSelector)new FileTypeSelector(FileType.FILE));
                return files;
            }
        }
        catch (FileSystemException e) {
            String message = logger.format("Failed to get all files at location {}", location);
            throw new RuntimeException(message, e);
        }
        return new FileObject[0];
    }

    public static Collection<FileObject> expand(Iterable<FileObject> locations) {
        HashSet<FileName> names = new HashSet<FileName>();
        ArrayList<FileObject> resources = new ArrayList<FileObject>();
        for (FileObject location : locations) {
            FileObject[] files;
            FileObject[] fileObjectArray = files = ResourceUtils.expand(location);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                FileObject file = fileObjectArray[n2];
                FileName name = file.getName();
                if (!names.contains(name)) {
                    names.add(name);
                    resources.add(file);
                }
                ++n2;
            }
        }
        return resources;
    }

    public static String relativeName(FileName resource, FileName base, boolean strict) {
        boolean isEqualOrAncestor = resource.equals(base) || resource.isAncestor(base);
        boolean isInSameFilesystem = resource.getRoot().equals(base.getRoot());
        if (isEqualOrAncestor || !strict && isInSameFilesystem) {
            try {
                return base.getRelativeName(resource);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        return resource.getURI();
    }

    public static FileObject resolveFile(FileObject baseFile, String name) throws FileSystemException {
        return baseFile.getFileSystem().getFileSystemManager().resolveFile(baseFile, name);
    }

    public static URL resolveJavaResource(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ResourceUtils.class.getClassLoader();
        }
        return loader.getResource(name);
    }

    public static String readJavaResource(String name, Charset charset) throws IOException {
        return ResourceUtils.readInputStream(ResourceUtils.resolveJavaResource(name).openStream(), charset);
    }

    public static String readInputStream(InputStream inputStream, Charset charset) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(charset.name());
    }
}

