/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.ITerm;
import mb.statix.spec.ASpec;
import mb.statix.spec.RuleSet;
import org.metaborg.util.tuple.Tuple2;

public final class Spec
extends ASpec
implements Serializable {
    private final RuleSet rules;
    private final Set.Immutable<ITerm> edgeLabels;
    private final Set.Immutable<ITerm> dataLabels;
    private final SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions;
    private final boolean hasPrecomputedCriticalEdges;
    private transient int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long ALL_LABELS_LAZY_INIT_BIT = 1L;
    private transient Set.Immutable<ITerm> allLabels;
    private static final long serialVersionUID = 42L;

    private Spec(RuleSet rules, Set.Immutable<ITerm> edgeLabels, Set.Immutable<ITerm> dataLabels, SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        this.rules = Objects.requireNonNull(rules, "rules");
        this.edgeLabels = Objects.requireNonNull(edgeLabels, "edgeLabels");
        this.dataLabels = Objects.requireNonNull(dataLabels, "dataLabels");
        this.scopeExtensions = Objects.requireNonNull(scopeExtensions, "scopeExtensions");
        this.hasPrecomputedCriticalEdges = super.hasPrecomputedCriticalEdges();
    }

    private Spec(Builder builder) {
        this.rules = builder.rules;
        this.edgeLabels = builder.edgeLabels;
        this.dataLabels = builder.dataLabels;
        this.scopeExtensions = builder.scopeExtensions;
        this.hasPrecomputedCriticalEdges = builder.hasPrecomputedCriticalEdgesIsSet() ? builder.hasPrecomputedCriticalEdges : super.hasPrecomputedCriticalEdges();
    }

    private Spec(RuleSet rules, Set.Immutable<ITerm> edgeLabels, Set.Immutable<ITerm> dataLabels, SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions, boolean hasPrecomputedCriticalEdges) {
        this.rules = rules;
        this.edgeLabels = edgeLabels;
        this.dataLabels = dataLabels;
        this.scopeExtensions = scopeExtensions;
        this.hasPrecomputedCriticalEdges = hasPrecomputedCriticalEdges;
    }

    @Override
    public RuleSet rules() {
        return this.rules;
    }

    @Override
    public Set.Immutable<ITerm> edgeLabels() {
        return this.edgeLabels;
    }

    @Override
    public Set.Immutable<ITerm> dataLabels() {
        return this.dataLabels;
    }

    @Override
    public SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions() {
        return this.scopeExtensions;
    }

    @Override
    public boolean hasPrecomputedCriticalEdges() {
        return this.hasPrecomputedCriticalEdges;
    }

    public final Spec withRules(RuleSet value) {
        if (this.rules == value) {
            return this;
        }
        RuleSet newValue = Objects.requireNonNull(value, "rules");
        return new Spec(newValue, this.edgeLabels, this.dataLabels, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withEdgeLabels(Set.Immutable<ITerm> value) {
        if (this.edgeLabels == value) {
            return this;
        }
        Set.Immutable<ITerm> newValue = Objects.requireNonNull(value, "edgeLabels");
        return new Spec(this.rules, newValue, this.dataLabels, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withDataLabels(Set.Immutable<ITerm> value) {
        if (this.dataLabels == value) {
            return this;
        }
        Set.Immutable<ITerm> newValue = Objects.requireNonNull(value, "dataLabels");
        return new Spec(this.rules, this.edgeLabels, newValue, this.scopeExtensions, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withScopeExtensions(SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> value) {
        if (this.scopeExtensions == value) {
            return this;
        }
        SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> newValue = Objects.requireNonNull(value, "scopeExtensions");
        return new Spec(this.rules, this.edgeLabels, this.dataLabels, newValue, this.hasPrecomputedCriticalEdges);
    }

    public final Spec withHasPrecomputedCriticalEdges(boolean value) {
        if (this.hasPrecomputedCriticalEdges == value) {
            return this;
        }
        return new Spec(this.rules, this.edgeLabels, this.dataLabels, this.scopeExtensions, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Spec && this.equalTo(0, (Spec)another);
    }

    private boolean equalTo(int synthetic, Spec another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.rules.equals(another.rules) && this.edgeLabels.equals(another.edgeLabels) && this.dataLabels.equals(another.dataLabels) && this.scopeExtensions.equals(another.scopeExtensions) && this.hasPrecomputedCriticalEdges == another.hasPrecomputedCriticalEdges;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.rules.hashCode();
        h += (h << 5) + this.edgeLabels.hashCode();
        h += (h << 5) + this.dataLabels.hashCode();
        h += (h << 5) + this.scopeExtensions.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hasPrecomputedCriticalEdges);
        return h;
    }

    public String toString() {
        return "Spec{rules=" + this.rules + ", edgeLabels=" + this.edgeLabels + ", dataLabels=" + this.dataLabels + ", scopeExtensions=" + this.scopeExtensions + ", hasPrecomputedCriticalEdges=" + this.hasPrecomputedCriticalEdges + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<ITerm> allLabels() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Spec spec = this;
            synchronized (spec) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.allLabels = Objects.requireNonNull(super.allLabels(), "allLabels");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.allLabels;
    }

    public static Spec of(RuleSet rules, Set.Immutable<ITerm> edgeLabels, Set.Immutable<ITerm> dataLabels, SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions) {
        return new Spec(rules, edgeLabels, dataLabels, scopeExtensions);
    }

    public static Spec copyOf(ASpec instance) {
        if (instance instanceof Spec) {
            return (Spec)instance;
        }
        return Spec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ Spec(Builder builder, Spec spec) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_RULES = 1L;
        private static final long INIT_BIT_EDGE_LABELS = 2L;
        private static final long INIT_BIT_DATA_LABELS = 4L;
        private static final long INIT_BIT_SCOPE_EXTENSIONS = 8L;
        private static final long OPT_BIT_HAS_PRECOMPUTED_CRITICAL_EDGES = 1L;
        private long initBits = 15L;
        private long optBits;
        private RuleSet rules;
        private Set.Immutable<ITerm> edgeLabels;
        private Set.Immutable<ITerm> dataLabels;
        private SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions;
        private boolean hasPrecomputedCriticalEdges;

        private Builder() {
        }

        public final Builder from(ASpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.rules(instance.rules());
            this.edgeLabels(instance.edgeLabels());
            this.dataLabels(instance.dataLabels());
            this.scopeExtensions(instance.scopeExtensions());
            this.hasPrecomputedCriticalEdges(instance.hasPrecomputedCriticalEdges());
            return this;
        }

        public final Builder rules(RuleSet rules) {
            this.rules = Objects.requireNonNull(rules, "rules");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder edgeLabels(Set.Immutable<ITerm> edgeLabels) {
            this.edgeLabels = Objects.requireNonNull(edgeLabels, "edgeLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder dataLabels(Set.Immutable<ITerm> dataLabels) {
            this.dataLabels = Objects.requireNonNull(dataLabels, "dataLabels");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder scopeExtensions(SetMultimap.Immutable<String, Tuple2<Integer, ITerm>> scopeExtensions) {
            this.scopeExtensions = Objects.requireNonNull(scopeExtensions, "scopeExtensions");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder hasPrecomputedCriticalEdges(boolean hasPrecomputedCriticalEdges) {
            this.hasPrecomputedCriticalEdges = hasPrecomputedCriticalEdges;
            this.optBits |= 1L;
            return this;
        }

        public Spec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Spec(this, null);
        }

        private boolean hasPrecomputedCriticalEdgesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("rules");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("edgeLabels");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("dataLabels");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("scopeExtensions");
            }
            return "Cannot build Spec, some of required attributes are not set " + attributes;
        }
    }
}

