/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.Constraints;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.StateUtil;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate1;
import org.metaborg.util.iterators.Iterables2;
import org.metaborg.util.tuple.Tuple2;

public class PreSolvedConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set.Immutable<ITermVar> vars;
    private final IUniDisunifier.Immutable unifier;
    private final List<IConstraint> constraints;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final ICompleteness.Immutable bodyCriticalEdges;
    private volatile Set.Immutable<ITermVar> freeVars;

    private PreSolvedConstraint(Iterable<ITermVar> vars, IUniDisunifier.Immutable unifier, List<IConstraint> constraints, @Nullable IConstraint cause, @Nullable ICompleteness.Immutable bodyCriticalEdges, @Nullable Set.Immutable<ITermVar> freeVars) {
        this.vars = CapsuleUtil.toSet(vars);
        this.unifier = unifier;
        this.constraints = constraints;
        this.cause = cause;
        this.bodyCriticalEdges = bodyCriticalEdges;
        this.freeVars = freeVars;
    }

    public Set.Immutable<ITermVar> vars() {
        return this.vars;
    }

    public IUniDisunifier.Immutable unifier() {
        return this.unifier;
    }

    public List<IConstraint> constraints() {
        return this.constraints;
    }

    public Set.Immutable<ITermVar> freeVars() {
        Set.Immutable result = this.freeVars;
        if (result == null) {
            Set.Transient _freeVars = CapsuleUtil.transientSet();
            this.doVisitFreeVars(arg_0 -> _freeVars.__insert(arg_0));
            this.freeVars = result = _freeVars.freeze();
        }
        return result;
    }

    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.freeVars().forEach(onFreeVar::apply);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.unifier.varSet().forEach(v -> {
            if (!this.vars.contains(v)) {
                onFreeVar.apply((ITermVar)v);
            }
        });
        for (IConstraint constraint : this.constraints) {
            constraint.visitFreeVars(v -> {
                if (!this.vars.contains(v)) {
                    onFreeVar.apply((ITermVar)v);
                }
            });
        }
    }

    public void visitVars(Action1<ITermVar> onVar) {
        this.vars.forEach(onVar::apply);
        this.unifier.varSet().forEach(onVar::apply);
        for (IConstraint constraint : this.constraints) {
            Constraints.vars(constraint, onVar);
        }
    }

    public PreSolvedConstraint apply(IRenaming subst) {
        Set.Immutable<ITermVar> vars = this.vars;
        IUniDisunifier.Immutable unifier = this.unifier;
        List constraints = this.constraints;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        vars = CapsuleUtil.toSet(subst.rename((Set<ITermVar>)vars));
        unifier = unifier.rename(subst);
        constraints = constraints.stream().map(c -> c.apply(subst)).collect(ImList.Immutable.toImmutableList());
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(subst);
        }
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, constraints, this.cause, bodyCriticalEdges, null);
    }

    public IConstraint toConstraint() {
        IConstraint newConstraint = Constraints.conjoin(Iterables2.fromConcat(StateUtil.asConstraint(this.unifier), this.constraints));
        if (!this.vars.isEmpty() || this.bodyCriticalEdges != null && !this.bodyCriticalEdges.isEmpty()) {
            newConstraint = new CExists((Iterable<ITermVar>)this.vars, newConstraint, this.cause, this.bodyCriticalEdges).withCause(this.cause);
        }
        return newConstraint;
    }

    public PreSolvedConstraint intern(Set.Immutable<ITermVar> otherExistentials, IUniDisunifier.Immutable otherUnifier) {
        IUniDisunifier.Result result;
        if (otherUnifier.isEmpty()) {
            return this;
        }
        Set.Immutable otherFreeVars = otherUnifier.varSet().__removeAll(otherExistentials);
        FreshVars fresh = new FreshVars(new Set[]{otherFreeVars, this.freeVars()});
        IRenaming otherRen = fresh.fresh((Set<ITermVar>)otherExistentials);
        if (!otherRen.isEmpty()) {
            otherUnifier = otherUnifier.rename(otherRen);
        }
        IUniDisunifier.Immutable unifier = this.unifier;
        List constraints = this.constraints;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        IRenaming ren = fresh.fresh((Set<ITermVar>)this.vars);
        if (!ren.isEmpty()) {
            unifier = unifier.rename(ren);
            constraints = constraints.stream().map(c -> c.apply(ren.asSubstitution())).collect(ImList.Immutable.toImmutableList());
            if (bodyCriticalEdges != null) {
                bodyCriticalEdges = bodyCriticalEdges.apply(ren);
            }
        }
        Set.Immutable<ITermVar> vars = fresh.fix();
        try {
            result = unifier.uniDisunify(otherUnifier).orElse(null);
            if (result == null) {
                return this.contradiction();
            }
        }
        catch (OccursException e) {
            return this.contradiction();
        }
        unifier = result.unifier();
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.updateAll((Iterable<? extends ITermVar>)((IUnifier.Immutable)result.result()).domainSet(), (IUnifier)result.result());
        }
        if (freeVars != null) {
            freeVars = freeVars.__insertAll((Set)otherFreeVars);
        }
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, constraints, this.cause, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    public PreSolvedConstraint intern(Set.Immutable<ITermVar> otherExistentials, IUnifier.Immutable otherUnifier) {
        IUniDisunifier.Result result;
        if (otherUnifier.isEmpty()) {
            return this;
        }
        Set.Immutable otherFreeVars = otherUnifier.varSet().__removeAll(otherExistentials);
        FreshVars fresh = new FreshVars(new Set[]{otherFreeVars, this.freeVars()});
        IRenaming otherRen = fresh.fresh((Set<ITermVar>)otherExistentials);
        if (!otherRen.isEmpty()) {
            otherUnifier = otherUnifier.rename(otherRen);
        }
        IUniDisunifier.Immutable unifier = this.unifier;
        List constraints = this.constraints;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        IRenaming ren = fresh.fresh((Set<ITermVar>)this.vars);
        if (!ren.isEmpty()) {
            unifier = unifier.rename(ren);
            constraints = constraints.stream().map(c -> c.apply(ren.asSubstitution())).collect(ImList.Immutable.toImmutableList());
            if (bodyCriticalEdges != null) {
                bodyCriticalEdges = bodyCriticalEdges.apply(ren);
            }
        }
        Set.Immutable<ITermVar> vars = fresh.fix();
        try {
            result = unifier.unify(otherUnifier).orElse(null);
            if (result == null) {
                return this.contradiction();
            }
        }
        catch (OccursException e) {
            return this.contradiction();
        }
        unifier = result.unifier();
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.updateAll((Iterable<? extends ITermVar>)((IUnifier.Immutable)result.result()).domainSet(), (IUnifier)result.result());
        }
        if (freeVars != null) {
            freeVars = freeVars.__insertAll((Set)otherFreeVars);
        }
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, constraints, this.cause, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    public PreSolvedConstraint unsafeIntern(Set.Immutable<ITermVar> otherExistentials, IUniDisunifier otherUnifier) {
        IUniDisunifier.Result result;
        if (otherUnifier.isEmpty()) {
            return this;
        }
        Set.Immutable vars = this.vars;
        IUniDisunifier.Immutable unifier = this.unifier;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        try {
            result = unifier.uniDisunify(otherUnifier).orElse(null);
            if (result == null) {
                return this.contradiction();
            }
        }
        catch (OccursException e) {
            return this.contradiction();
        }
        vars = vars.__insertAll(otherExistentials);
        unifier = result.unifier();
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.updateAll((Iterable<? extends ITermVar>)((IUnifier.Immutable)result.result()).domainSet(), (IUnifier)result.result());
        }
        if (freeVars != null) {
            freeVars = freeVars.__insertAll((Set)unifier.varSet().__removeAll((Set)vars));
        }
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, this.constraints, this.cause, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    public PreSolvedConstraint unsafeIntern(Set.Immutable<ITermVar> otherExistentials, IUnifier otherUnifier) {
        IUniDisunifier.Result result;
        if (otherUnifier.isEmpty()) {
            return this;
        }
        Set.Immutable vars = this.vars;
        IUniDisunifier.Immutable unifier = this.unifier;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        try {
            result = unifier.unify(otherUnifier).orElse(null);
            if (result == null) {
                return this.contradiction();
            }
        }
        catch (OccursException e) {
            return this.contradiction();
        }
        vars = vars.__insertAll(otherExistentials);
        unifier = result.unifier();
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.updateAll((Iterable<? extends ITermVar>)((IUnifier.Immutable)result.result()).domainSet(), (IUnifier)result.result());
        }
        if (freeVars != null) {
            freeVars = freeVars.__insertAll((Set)unifier.varSet().__removeAll((Set)vars));
        }
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, this.constraints, this.cause, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    private PreSolvedConstraint contradiction() {
        return new PreSolvedConstraint((Iterable<ITermVar>)CapsuleUtil.immutableSet(), PersistentUniDisunifier.Immutable.of(), (List<IConstraint>)ImList.Immutable.of(new IConstraint[]{new CFalse()}), this.cause, this.bodyCriticalEdges == null ? null : Completeness.Immutable.of(), (Set.Immutable<ITermVar>)CapsuleUtil.immutableSet());
    }

    private static PreSolvedConstraint contradiction(IConstraint constraint) {
        return new PreSolvedConstraint((Iterable<ITermVar>)CapsuleUtil.immutableSet(), PersistentUniDisunifier.Immutable.of(), (List<IConstraint>)ImList.Immutable.of(new IConstraint[]{new CFalse()}), constraint.cause().orElse(null), constraint.bodyCriticalEdges().map(bce -> Completeness.Immutable.of()).orElse(null), (Set.Immutable<ITermVar>)CapsuleUtil.immutableSet());
    }

    public Tuple2<ISubstitution.Immutable, PreSolvedConstraint> extern(Iterable<ITermVar> externVars) {
        Set.Immutable<ITermVar> freeVars = this.freeVars();
        Set.Immutable externVarSet = CapsuleUtil.toSet(externVars).__retainAll(freeVars);
        Set.Immutable vars = this.vars;
        IUniDisunifier.Transient _unifier = this.unifier.melt();
        ISubstitution.Immutable subst = PersistentSubstitution.Immutable.of();
        for (ITermVar var : externVarSet) {
            subst = subst.put(var, _unifier.findRecursive(var));
        }
        Set<ITermVar> externTermVars = subst.rangeSet();
        vars = vars.__removeAll(externTermVars);
        Set.Immutable newFreeVars = Constraints.freeVars(this.constraints).__insertAll(_unifier.varSet()).__removeAll((Set)vars);
        Set.Immutable lostVars = externVarSet.__removeAll(externTermVars).__retainAll((Set)newFreeVars);
        vars = vars.__insertAll((Set)lostVars);
        Set.Immutable capturedVars = freeVars.__removeAll((Set)externVarSet).__retainAll(externTermVars);
        if (!capturedVars.isEmpty()) {
            FreshVars fresh = new FreshVars(new Set[]{freeVars, externTermVars, vars});
            IRenaming ren = fresh.fresh((Set<ITermVar>)capturedVars);
            subst = subst.compose(ren.asSubstitution());
            try {
                if (!_unifier.unify(ren.entrySet()).isPresent()) {
                    throw new IllegalStateException();
                }
            }
            catch (OccursException ex) {
                throw new IllegalStateException();
            }
        }
        return Tuple2.of(subst, new PreSolvedConstraint((Iterable<ITermVar>)vars, _unifier.freeze(), this.constraints, this.cause, this.bodyCriticalEdges, null));
    }

    public PreSolvedConstraint cleanup() {
        Set.Immutable<ITermVar> constraintFreeVars = Constraints.freeVars(this.constraints);
        Set.Immutable relevantVars = this.freeVars().__insertAll(constraintFreeVars);
        Set.Immutable irrelevantVars = this.unifier.varSet().__removeAll((Set)relevantVars);
        IUniDisunifier.Immutable unifier = this.unifier.removeAll(irrelevantVars).unifier();
        Set.Immutable vars = this.vars.__retainAll((Set)constraintFreeVars.__insertAll(unifier.varSet()));
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier, this.constraints, this.cause, this.bodyCriticalEdges, null);
    }

    public static PreSolvedConstraint of(IConstraint constraint) {
        Set.Immutable<ITermVar> freeVars = constraint.freeVars();
        FreshVars fresh = new FreshVars((Iterable<ITermVar>)freeVars);
        IUniDisunifier.Transient unifier = PersistentUniDisunifier.Immutable.of().melt();
        ArrayList<IConstraint> constraints = new ArrayList<IConstraint>();
        Completeness.Transient bodyCriticalEdges = Completeness.Transient.of();
        ArrayList<IConstraint> failures = new ArrayList<IConstraint>();
        HashMap<IConstraint, Delay> delays = new HashMap<IConstraint, Delay>();
        PreSolvedConstraint.preSolve(constraint, fresh::fresh, unifier, Predicate1.never(), new HashSet<ITermVar>(), constraints, bodyCriticalEdges, new HashMap<ITermVar, ITermVar>(), failures, delays, null, false);
        if (!failures.isEmpty()) {
            return PreSolvedConstraint.contradiction(constraint);
        }
        if (!delays.isEmpty()) {
            throw new IllegalArgumentException("Unexpected delays: " + delays);
        }
        Set.Immutable<ITermVar> vars = fresh.fix();
        return new PreSolvedConstraint((Iterable<ITermVar>)vars, unifier.freeze(), (List<IConstraint>)constraints, constraint.cause().orElse(null), bodyCriticalEdges.freeze(), freeVars);
    }

    public static void preSolve(IConstraint constraint, Function1<Set<ITermVar>, IRenaming> fresh, IUniDisunifier.Transient unifier, Predicate1<ITermVar> isRigid, Set<ITermVar> updatedVars, Collection<IConstraint> constraints, ICompleteness.Transient bodyCriticalEdges, Map<ITermVar, ITermVar> existentials, Collection<IConstraint> failures, Map<IConstraint, Delay> delays, @Nullable IConstraint cause, boolean returnOnFirstErrorOrDelay) {
        LinkedList<IConstraint> worklist = new LinkedList<IConstraint>();
        worklist.push(constraint);
        AtomicBoolean first = new AtomicBoolean(true);
        while (!worklist.isEmpty()) {
            IConstraint c = (IConstraint)worklist.removeLast();
            boolean okay = c.match(Constraints.cases(carith -> {
                constraints.add(c.withCause(cause));
                return true;
            }, conj -> {
                worklist.addAll(Constraints.disjoin(conj));
                return true;
            }, cequal -> {
                try {
                    IUnifier.Immutable result = unifier.unify(cequal.term1(), cequal.term2(), isRigid).orElse(null);
                    if (result == null) {
                        failures.add(cequal.withCause(cause));
                        return false;
                    }
                    updatedVars.addAll((Collection<ITermVar>)result.domainSet());
                    bodyCriticalEdges.updateAll((Iterable<? extends ITermVar>)result.domainSet(), result);
                    return true;
                }
                catch (OccursException e) {
                    failures.add(cequal.withCause(cause));
                    return false;
                }
                catch (RigidException e) {
                    delays.put((IConstraint)cequal, Delay.ofVars(e.vars()));
                    return false;
                }
            }, cexists -> {
                IRenaming renaming = (IRenaming)fresh.apply((Set<ITermVar>)cexists.vars());
                if (first.get()) {
                    existentials.putAll((Map<ITermVar, ITermVar>)renaming.asMap());
                }
                worklist.add(cexists.constraint().apply(renaming));
                cexists.bodyCriticalEdges().ifPresent(bce -> bodyCriticalEdges.addAll(bce.apply(renaming), unifier));
                return true;
            }, cfalse -> {
                failures.add(cfalse.withCause(cause));
                return false;
            }, cinequal -> {
                try {
                    if (!unifier.disunify((Iterable<ITermVar>)cinequal.universals(), cinequal.term1(), cinequal.term2(), isRigid).isPresent()) {
                        failures.add(cinequal.withCause(cause));
                        return false;
                    }
                }
                catch (RigidException e) {
                    delays.put((IConstraint)cinequal, Delay.ofVars(e.vars()));
                    return false;
                }
                return true;
            }, cnew -> {
                constraints.add(c.withCause(cause));
                return true;
            }, cquery -> {
                constraints.add(c.withCause(cause));
                return true;
            }, ctelledge -> {
                constraints.add(c.withCause(cause));
                return true;
            }, castid -> {
                constraints.add(c.withCause(cause));
                return true;
            }, castprop -> {
                constraints.add(c.withCause(cause));
                return true;
            }, ctrue -> true, ctry -> {
                constraints.add(c.withCause(cause));
                return true;
            }, cuser -> {
                constraints.add(c.withCause(cause));
                return true;
            }));
            first.set(false);
            if (okay || !returnOnFirstErrorOrDelay) continue;
            return;
        }
    }

    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(termToString.format((Iterable<? extends ITerm>)this.vars)).append("} ");
        if (!this.unifier.isEmpty()) {
            sb.append(StateUtil.asConstraint(this.unifier).stream().map(c -> c.toString(termToString)).collect(Collectors.joining(", ", "", " | ")));
        }
        sb.append(Constraints.toString(this.constraints, termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }
}

