/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.spec.AApplyResult;

public final class ApplyResult
extends AApplyResult
implements Serializable {
    private final Diseq guard;
    private final IConstraint body;
    private final ICompleteness.Immutable criticalEdges;
    private final ISubstitution.Immutable substitution;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private ApplyResult(Optional<? extends Diseq> guard, IConstraint body, ICompleteness.Immutable criticalEdges, ISubstitution.Immutable substitution) {
        this.guard = guard.orElse(null);
        this.body = Objects.requireNonNull(body, "body");
        this.criticalEdges = Objects.requireNonNull(criticalEdges, "criticalEdges");
        this.substitution = Objects.requireNonNull(substitution, "substitution");
    }

    private ApplyResult(ApplyResult original, Diseq guard, IConstraint body, ICompleteness.Immutable criticalEdges, ISubstitution.Immutable substitution) {
        this.guard = guard;
        this.body = body;
        this.criticalEdges = criticalEdges;
        this.substitution = substitution;
    }

    @Override
    public Optional<Diseq> guard() {
        return Optional.ofNullable(this.guard);
    }

    @Override
    public IConstraint body() {
        return this.body;
    }

    @Override
    public ICompleteness.Immutable criticalEdges() {
        return this.criticalEdges;
    }

    @Override
    public ISubstitution.Immutable substitution() {
        return this.substitution;
    }

    public final ApplyResult withGuard(Diseq value) {
        Diseq newValue = Objects.requireNonNull(value, "guard");
        if (this.guard == newValue) {
            return this;
        }
        return new ApplyResult(this, newValue, this.body, this.criticalEdges, this.substitution);
    }

    public final ApplyResult withGuard(Optional<? extends Diseq> optional) {
        Diseq value = optional.orElse(null);
        if (this.guard == value) {
            return this;
        }
        return new ApplyResult(this, value, this.body, this.criticalEdges, this.substitution);
    }

    public final ApplyResult withBody(IConstraint value) {
        if (this.body == value) {
            return this;
        }
        IConstraint newValue = Objects.requireNonNull(value, "body");
        return new ApplyResult(this, this.guard, newValue, this.criticalEdges, this.substitution);
    }

    public final ApplyResult withCriticalEdges(ICompleteness.Immutable value) {
        if (this.criticalEdges == value) {
            return this;
        }
        ICompleteness.Immutable newValue = Objects.requireNonNull(value, "criticalEdges");
        return new ApplyResult(this, this.guard, this.body, newValue, this.substitution);
    }

    public final ApplyResult withSubstitution(ISubstitution.Immutable value) {
        if (this.substitution == value) {
            return this;
        }
        ISubstitution.Immutable newValue = Objects.requireNonNull(value, "substitution");
        return new ApplyResult(this, this.guard, this.body, this.criticalEdges, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplyResult && this.equalTo(0, (ApplyResult)another);
    }

    private boolean equalTo(int synthetic, ApplyResult another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.guard, another.guard) && this.body.equals(another.body) && this.criticalEdges.equals(another.criticalEdges) && this.substitution.equals(another.substitution);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guard);
        h += (h << 5) + this.body.hashCode();
        h += (h << 5) + this.criticalEdges.hashCode();
        h += (h << 5) + this.substitution.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ApplyResult{");
        if (this.guard != null) {
            builder.append("guard=").append(this.guard);
        }
        if (builder.length() > 12) {
            builder.append(", ");
        }
        builder.append("body=").append(this.body);
        builder.append(", ");
        builder.append("criticalEdges=").append(this.criticalEdges);
        builder.append(", ");
        builder.append("substitution=").append(this.substitution);
        return builder.append("}").toString();
    }

    public static ApplyResult of(Optional<? extends Diseq> guard, IConstraint body, ICompleteness.Immutable criticalEdges, ISubstitution.Immutable substitution) {
        return new ApplyResult(guard, body, criticalEdges, substitution);
    }

    public static ApplyResult copyOf(AApplyResult instance) {
        if (instance instanceof ApplyResult) {
            return (ApplyResult)instance;
        }
        return ApplyResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ ApplyResult(ApplyResult applyResult, Diseq diseq, IConstraint iConstraint, ICompleteness.Immutable immutable, ISubstitution.Immutable immutable2, ApplyResult applyResult2) {
        this(applyResult, diseq, iConstraint, immutable, immutable2);
    }

    public static final class Builder {
        private static final long INIT_BIT_BODY = 1L;
        private static final long INIT_BIT_CRITICAL_EDGES = 2L;
        private static final long INIT_BIT_SUBSTITUTION = 4L;
        private long initBits = 7L;
        private Diseq guard;
        private IConstraint body;
        private ICompleteness.Immutable criticalEdges;
        private ISubstitution.Immutable substitution;

        private Builder() {
        }

        public final Builder from(AApplyResult instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<Diseq> guardOptional = instance.guard();
            if (guardOptional.isPresent()) {
                this.guard(guardOptional);
            }
            this.body(instance.body());
            this.criticalEdges(instance.criticalEdges());
            this.substitution(instance.substitution());
            return this;
        }

        public final Builder guard(Diseq guard) {
            this.guard = Objects.requireNonNull(guard, "guard");
            return this;
        }

        public final Builder guard(Optional<? extends Diseq> guard) {
            this.guard = guard.orElse(null);
            return this;
        }

        public final Builder body(IConstraint body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder criticalEdges(ICompleteness.Immutable criticalEdges) {
            this.criticalEdges = Objects.requireNonNull(criticalEdges, "criticalEdges");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder substitution(ISubstitution.Immutable substitution) {
            this.substitution = Objects.requireNonNull(substitution, "substitution");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ApplyResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplyResult(null, this.guard, this.body, this.criticalEdges, this.substitution, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("body");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("criticalEdges");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("substitution");
            }
            return "Cannot build ApplyResult, some of required attributes are not set " + attributes;
        }
    }
}

