/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CTry;
import mb.statix.solver.persistent.step.ACTryStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CTryStep
extends ACTryStep {
    private final CTry constraint;
    private final StepResult result;
    private transient int hashCode;

    private CTryStep(CTry constraint, StepResult result) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
    }

    private CTryStep(CTryStep original, CTry constraint, StepResult result) {
        this.constraint = constraint;
        this.result = result;
    }

    @Override
    public CTry constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    public final CTryStep withConstraint(CTry value) {
        if (this.constraint == value) {
            return this;
        }
        CTry newValue = Objects.requireNonNull(value, "constraint");
        return new CTryStep(this, newValue, this.result);
    }

    public final CTryStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CTryStep(this, this.constraint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CTryStep && this.equalTo(0, (CTryStep)another);
    }

    private boolean equalTo(int synthetic, CTryStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "CTryStep{constraint=" + this.constraint + ", result=" + this.result + "}";
    }

    public static CTryStep of(CTry constraint, StepResult result) {
        return new CTryStep(constraint, result);
    }

    public static CTryStep copyOf(ACTryStep instance) {
        if (instance instanceof CTryStep) {
            return (CTryStep)instance;
        }
        return CTryStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CTryStep(CTryStep cTryStep, CTry cTry, StepResult stepResult, CTryStep cTryStep2) {
        this(cTryStep, cTry, stepResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CTry constraint;
        private StepResult result;

        private Builder() {
        }

        public final Builder from(ACTryStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof ACTryStep) {
                instance = (ACTryStep)object;
                this.constraint(((ACTryStep)instance).constraint());
            }
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
        }

        public final Builder constraint(CTry constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CTryStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CTryStep(null, this.constraint, this.result, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CTryStep, some of required attributes are not set " + attributes;
        }
    }
}

