/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent.step;

import java.util.ArrayList;
import java.util.Objects;
import mb.statix.constraints.CConj;
import mb.statix.solver.persistent.step.ACConjStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;

public final class CConjStep
extends ACConjStep {
    private final CConj constraint;
    private final StepResult result;
    private transient int hashCode;

    private CConjStep(CConj constraint, StepResult result) {
        this.constraint = Objects.requireNonNull(constraint, "constraint");
        this.result = Objects.requireNonNull(result, "result");
    }

    private CConjStep(CConjStep original, CConj constraint, StepResult result) {
        this.constraint = constraint;
        this.result = result;
    }

    @Override
    public CConj constraint() {
        return this.constraint;
    }

    @Override
    public StepResult result() {
        return this.result;
    }

    public final CConjStep withConstraint(CConj value) {
        if (this.constraint == value) {
            return this;
        }
        CConj newValue = Objects.requireNonNull(value, "constraint");
        return new CConjStep(this, newValue, this.result);
    }

    public final CConjStep withResult(StepResult value) {
        if (this.result == value) {
            return this;
        }
        StepResult newValue = Objects.requireNonNull(value, "result");
        return new CConjStep(this, this.constraint, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CConjStep && this.equalTo(0, (CConjStep)another);
    }

    private boolean equalTo(int synthetic, CConjStep another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.constraint.equals(another.constraint) && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.constraint.hashCode();
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "CConjStep{constraint=" + this.constraint + ", result=" + this.result + "}";
    }

    public static CConjStep of(CConj constraint, StepResult result) {
        return new CConjStep(constraint, result);
    }

    public static CConjStep copyOf(ACConjStep instance) {
        if (instance instanceof CConjStep) {
            return (CConjStep)instance;
        }
        return CConjStep.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ CConjStep(CConjStep cConjStep, CConj cConj, StepResult stepResult, CConjStep cConjStep2) {
        this(cConjStep, cConj, stepResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_CONSTRAINT = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private long initBits = 3L;
        private CConj constraint;
        private StepResult result;

        private Builder() {
        }

        public final Builder from(IStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ACConjStep instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            IStep instance;
            if (object instanceof IStep) {
                instance = (IStep)object;
                this.result(instance.result());
            }
            if (object instanceof ACConjStep) {
                instance = (ACConjStep)object;
                this.constraint(((ACConjStep)instance).constraint());
            }
        }

        public final Builder constraint(CConj constraint) {
            this.constraint = Objects.requireNonNull(constraint, "constraint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(StepResult result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CConjStep build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CConjStep(null, this.constraint, this.result, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("constraint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build CConjStep, some of required attributes are not set " + attributes;
        }
    }
}

