/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import java.io.Serializable;
import java.util.Collection;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.substitution.IReplacement;
import mb.statix.solver.ITermProperty;

public class SingletonTermProperty
implements ITermProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ITerm value;

    private SingletonTermProperty(ITerm value) {
        this.value = value;
    }

    @Override
    public ITermProperty.Multiplicity multiplicity() {
        return ITermProperty.Multiplicity.SINGLETON;
    }

    @Override
    public ITerm value() {
        return this.value;
    }

    @Override
    public Collection<ITerm> values() {
        throw new UnsupportedOperationException("Singleton property does not support multiple values.");
    }

    @Override
    public ITermProperty addValue(ITerm value) {
        throw new UnsupportedOperationException("Cannot add value to singleton property.");
    }

    @Override
    public ITermProperty replace(IReplacement replacement) {
        return SingletonTermProperty.of(replacement.apply(this.value));
    }

    public static ITermProperty of(ITerm value) {
        return new SingletonTermProperty(value);
    }
}

