/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.persistent;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.AbstractApplTerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.Renaming;
import mb.nabl2.terms.unification.OccursException;
import mb.nabl2.terms.unification.RigidException;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.Diseq;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.scopegraph.oopsla20.INameResolution;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.scopegraph.oopsla20.reference.Env;
import mb.scopegraph.oopsla20.reference.IncompleteException;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.oopsla20.reference.ResolutionInterpreter;
import mb.statix.constraints.CArith;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.CConj;
import mb.statix.constraints.CEqual;
import mb.statix.constraints.CExists;
import mb.statix.constraints.CFalse;
import mb.statix.constraints.CInequal;
import mb.statix.constraints.CNew;
import mb.statix.constraints.CTellEdge;
import mb.statix.constraints.CTrue;
import mb.statix.constraints.CTry;
import mb.statix.constraints.CUser;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.IResolveQuery;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.constraints.messages.MessageUtil;
import mb.statix.scopegraph.AScope;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.ConstraintContext;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IConstraintStore;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.CompletenessUtil;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.log.LazyDebugContext;
import mb.statix.solver.log.NullDebugContext;
import mb.statix.solver.persistent.BagTermProperty;
import mb.statix.solver.persistent.SingletonTermProperty;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverFatalErrorException;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.query.ConstraintQueries;
import mb.statix.solver.persistent.step.AResolveQueryStep;
import mb.statix.solver.persistent.step.CArithStep;
import mb.statix.solver.persistent.step.CAstIdStep;
import mb.statix.solver.persistent.step.CAstPropertyStep;
import mb.statix.solver.persistent.step.CConjStep;
import mb.statix.solver.persistent.step.CEqualStep;
import mb.statix.solver.persistent.step.CExistsStep;
import mb.statix.solver.persistent.step.CFalseStep;
import mb.statix.solver.persistent.step.CInequalStep;
import mb.statix.solver.persistent.step.CNewStep;
import mb.statix.solver.persistent.step.CTellEdgeStep;
import mb.statix.solver.persistent.step.CTrueStep;
import mb.statix.solver.persistent.step.CTryStep;
import mb.statix.solver.persistent.step.CUserStep;
import mb.statix.solver.persistent.step.IStep;
import mb.statix.solver.persistent.step.StepResult;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.solver.query.QueryProject;
import mb.statix.solver.query.ResolutionDelayException;
import mb.statix.solver.store.BaseConstraintStore;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.log.Level;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.task.RateLimitedCancel;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

class GreedySolver<TR extends SolverTracer.IResult<TR>> {
    private static final int CANCEL_RATE = 42;
    private static final int MAX_DEPTH = 32;
    private final Spec spec;
    private final IDebugContext debug;
    private final IConstraintStore constraints;
    private final ConstraintContext params;
    private final IProgress progress;
    private final ICancel cancel;
    private final int flags;
    private IState.Immutable state;
    private ICompleteness.Immutable completeness;
    @Nullable
    private Map.Immutable<ITermVar, ITermVar> existentials = null;
    private Set.Transient<ITermVar> updatedVars = CapsuleUtil.transientSet();
    private Set.Transient<CriticalEdge> removedEdges = CapsuleUtil.transientSet();
    private Map.Transient<IConstraint, IMessage> failed = CapsuleUtil.transientMap();
    private final SolverTracer<TR> tracer;
    private int solved = 0;
    private int criticalEdges = 0;

    private Set.Immutable<ITermVar> updatedVars() {
        Set.Immutable updatedVars = this.updatedVars.freeze();
        this.updatedVars = updatedVars.asTransient();
        return updatedVars;
    }

    private Set.Immutable<CriticalEdge> removedEdges() {
        Set.Immutable removedEdges = this.removedEdges.freeze();
        this.removedEdges = removedEdges.asTransient();
        return removedEdges;
    }

    private Map.Immutable<IConstraint, IMessage> failed() {
        Map.Immutable failed = this.failed.freeze();
        this.failed = failed.asTransient();
        return failed;
    }

    public GreedySolver(Spec spec, IState.Immutable state, IConstraint initialConstraint, IsComplete _isComplete, IDebugContext debug, IProgress progress, ICancel cancel, SolverTracer<TR> tracer, int flags) {
        if (!spec.hasPrecomputedCriticalEdges()) {
            debug.warn("Leaving precomputing critical edges to solver may result in duplicate work.", new Object[0]);
            this.spec = spec.precomputeCriticalEdges();
        } else {
            this.spec = spec;
        }
        this.state = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        Completeness.Transient _completeness = Completeness.Transient.of();
        Tuple2<IConstraint, ICompleteness.Immutable> initialConstraintAndCriticalEdges = CompletenessUtil.precomputeCriticalEdges(initialConstraint, spec.scopeExtensions());
        this.constraints.add(initialConstraintAndCriticalEdges._1());
        _completeness.addAll(initialConstraintAndCriticalEdges._2(), state.unifier());
        this.completeness = _completeness.freeze();
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (EdgeOrData<ITerm>)l, st.unifier()) && _isComplete.test(s, l, st);
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
        this.tracer = tracer;
        this.flags = flags;
    }

    public GreedySolver(Spec spec, IState.Immutable state, Iterable<IConstraint> constraints, Map<IConstraint, Delay> delays, ICompleteness.Immutable completeness, IsComplete _isComplete, IDebugContext debug, IProgress progress, ICancel cancel, SolverTracer<TR> tracer, int flags) {
        this.spec = spec;
        this.state = state;
        this.debug = debug;
        this.constraints = new BaseConstraintStore(debug);
        this.constraints.addAll(constraints);
        this.constraints.delayAll(delays.entrySet());
        this.completeness = completeness;
        IsComplete isComplete = (s, l, st) -> this.completeness.isComplete((Scope)s, (EdgeOrData<ITerm>)l, st.unifier()) && _isComplete.test(s, l, st);
        this.params = new ConstraintContext(isComplete, debug);
        this.progress = progress;
        this.cancel = new RateLimitedCancel(cancel, 42);
        this.tracer = tracer;
        this.flags = flags;
    }

    public SolverResult<TR> solve() throws InterruptedException {
        IConstraint constraint;
        this.debug.debug("Solving constraints", new Object[0]);
        while ((constraint = this.constraints.remove()) != null) {
            if (this.step(constraint, 32)) continue;
            this.debug.debug("Finished fast.", new Object[0]);
            return this.finishSolve();
        }
        if (this.constraints.activeSize() > 0) {
            this.debug.warn("Expected no remaining active constraints, but got ", this.constraints.activeSize());
        }
        return this.finishSolve();
    }

    protected SolverResult<TR> finishSolve() {
        Map.Immutable<IConstraint, Delay> delayed = this.constraints.delayed();
        this.debug.debug("Solved constraints with {} failed and {} remaining constraint(s).", this.failed.size(), this.constraints.delayedSize());
        if (this.debug.isEnabled(Level.Debug)) {
            for (Map.Entry entry : delayed.entrySet()) {
                Object[] objectArray = new Object[2];
                objectArray[0] = ((IConstraint)entry.getKey()).toString(this.state.unifier()::toString);
                objectArray[1] = entry.getValue();
                this.debug.debug(" * {} on {}", objectArray);
            }
        }
        Map.Immutable<ITermVar, ITermVar> existentials = Optional.ofNullable(this.existentials).orElse(Solver.NO_EXISTENTIALS);
        return SolverResult.of(this.spec, this.state, this.tracer.result(this.state), this.failed(), delayed, existentials, this.updatedVars(), this.removedEdges(), this.completeness).withTotalSolved(this.solved).withTotalCriticalEdges(this.criticalEdges);
    }

    private boolean success(IConstraint constraint, IState.Immutable newState, Set.Immutable<ITermVar> updatedVars, Collection<IConstraint> newConstraints, ICompleteness.Immutable newCriticalEdges, Map.Immutable<ITermVar, ITermVar> existentials, int fuel) throws InterruptedException {
        ICompleteness.Transient _completeness;
        ++this.solved;
        this.state = newState;
        IDebugContext subDebug = this.debug.subContext();
        if (this.existentials == null) {
            this.existentials = existentials;
        }
        IUniDisunifier.Immutable unifier = this.state.unifier();
        if (!updatedVars.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.updateAll((Iterable<? extends ITermVar>)updatedVars, unifier);
            this.completeness = _completeness.freeze();
            this.constraints.activateFromVars((Iterable<? extends ITermVar>)updatedVars, this.debug);
            this.updatedVars.__insertAll(updatedVars);
        }
        if (!newConstraints.isEmpty()) {
            _completeness = this.completeness.melt();
            _completeness.addAll(newCriticalEdges, unifier);
            this.completeness = _completeness.freeze();
            if (subDebug.isEnabled(Level.Debug) && !newConstraints.isEmpty()) {
                subDebug.debug("Simplified to:", new Object[0]);
                for (IConstraint newConstraint : newConstraints) {
                    subDebug.debug(" * {}", Solver.toString(newConstraint, unifier));
                }
            }
        }
        this.removeCompleteness(constraint);
        for (IConstraint newConstraint : newConstraints) {
            if (this.step(newConstraint, fuel - 1)) continue;
            return false;
        }
        this.tracer.onConstraintSolved(constraint, newState);
        return true;
    }

    private boolean delay(IConstraint constraint, Delay delay) {
        IDebugContext subDebug = this.debug.subContext();
        this.constraints.delay(constraint, delay);
        if (subDebug.isEnabled(Level.Debug)) {
            subDebug.debug("Delayed: {}", Solver.toString(constraint, this.state.unifier()));
        }
        this.tracer.onConstraintDelayed(constraint, this.state);
        return true;
    }

    private boolean fail(IConstraint constraint) {
        IMessage message = MessageUtil.findClosestMessage(constraint);
        this.failed.__put((Object)constraint, (Object)message);
        this.removeCompleteness(constraint);
        this.tracer.onConstraintFailed(constraint, this.state);
        return message.kind() != MessageKind.ERROR || (this.flags & 1) == 0;
    }

    private void removeCompleteness(IConstraint constraint) {
        ICompleteness.Transient _completeness = this.completeness.melt();
        if (!constraint.ownCriticalEdges().isPresent()) {
            throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
        }
        this.criticalEdges += constraint.ownCriticalEdges().get().entrySet().stream().mapToInt(e -> ((MultiSet.Immutable)e.getValue()).size()).sum();
        Set.Immutable<CriticalEdge> removedEdges = _completeness.removeAll(constraint.ownCriticalEdges().get(), this.state.unifier());
        this.completeness = _completeness.freeze();
        this.constraints.activateFromEdges((Iterable<? extends CriticalEdge>)removedEdges, this.debug);
        this.removedEdges.__insertAll(removedEdges);
    }

    private boolean queue(IConstraint constraint) {
        this.constraints.add(constraint);
        return true;
    }

    private boolean step(IConstraint constraint, int fuel) throws InterruptedException {
        try {
            if (fuel <= 0) {
                return this.queue(constraint);
            }
            IStep step = this.k(constraint);
            return this.applyStep(step, this.tracer.onStep(step, this.state), fuel);
        }
        catch (InterruptedException | SolverFatalErrorException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SolverFatalErrorException(e, constraint, this.state.unifier(), this.state.scopeGraph(), 4);
        }
    }

    private boolean applyStep(IStep step, Optional<StepResult> stepResultOverride, int fuel) throws InterruptedException {
        stepResultOverride.ifPresent(stepResult -> this.debug.debug("result override by tracer: {} (was {})", stepResult, step.result()));
        return stepResultOverride.orElse(step.result()).match((newState, updatedVars, newConstraints, newCriticalEdges, newExistentials) -> this.success(step.constraint(), newState, (Set.Immutable<ITermVar>)updatedVars, newConstraints, newCriticalEdges, (Map.Immutable<ITermVar, ITermVar>)newExistentials, fuel), ex -> this.fail(step.constraint()), delay -> this.delay(step.constraint(), (Delay)delay));
    }

    private IStep k(IConstraint constraint) throws InterruptedException {
        this.cancel.throwIfCancelled();
        this.tracer.onTrySolveConstraint(constraint, this.state);
        if (this.debug.isEnabled(Level.Debug)) {
            this.debug.debug("Solving {}", constraint.toString(Solver.shallowTermFormatter(this.state.unifier(), 4)));
        }
        return constraint.matchOrThrow(new IConstraint.CheckedCases<IStep, InterruptedException>(){

            @Override
            public IStep caseArith(CArith c) {
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                Optional<ITerm> term1 = c.expr1().isTerm();
                Optional<ITerm> term2 = c.expr2().isTerm();
                try {
                    if (c.op().isEquals() && term1.isPresent()) {
                        int i2 = c.expr2().eval(unifier);
                        CEqual eq = new CEqual(term1.get(), (ITerm)TermBuild.B.newInt(i2), c);
                        return CArithStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(ImList.Immutable.of(new IConstraint[]{eq})));
                    }
                    if (c.op().isEquals() && term2.isPresent()) {
                        int i1 = c.expr1().eval(unifier);
                        CEqual eq = new CEqual((ITerm)TermBuild.B.newInt(i1), term2.get(), c);
                        return CArithStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(ImList.Immutable.of(new IConstraint[]{eq})));
                    }
                    int i1 = c.expr1().eval(unifier);
                    int i2 = c.expr2().eval(unifier);
                    if (c.op().test(i1, i2)) {
                        return CArithStep.of(c, StepResult.success(GreedySolver.this.state));
                    }
                    return CArithStep.of(c, StepResult.failure());
                }
                catch (Delay d) {
                    return CArithStep.of(c, StepResult.delay(d));
                }
            }

            @Override
            public IStep caseConj(CConj c) {
                return CConjStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(Constraints.disjoin(c)));
            }

            @Override
            public IStep caseEqual(CEqual c) {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.unify(term1, term2, v -> GreedySolver.this.params.isRigid((ITermVar)v, GreedySolver.this.state)).orElse(null);
                    if (result != null) {
                        if (debug.isEnabled(Level.Debug)) {
                            debug.debug("Unification succeeded: {}", result.result());
                        }
                        IState.Immutable newState = GreedySolver.this.state.withUnifier(result.unifier());
                        Set.Immutable<ITermVar> updatedVars = ((IUnifier.Immutable)result.result()).domainSet();
                        return CEqualStep.of(c, StepResult.success(newState).withUpdatedVars(updatedVars), result);
                    }
                    if (debug.isEnabled(Level.Debug)) {
                        debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return CEqualStep.of(c, StepResult.failure(), null);
                }
                catch (OccursException e) {
                    if (debug.isEnabled(Level.Debug)) {
                        debug.debug("Unification failed: {} != {}", unifier.toString(term1), unifier.toString(term2));
                    }
                    return CEqualStep.of(c, StepResult.failure(e), null);
                }
                catch (RigidException e) {
                    return CEqualStep.of(c, StepResult.delay(Delay.ofVars(e.vars())), null);
                }
            }

            @Override
            public IStep caseExists(CExists c) {
                Renaming.Builder _existentials = Renaming.builder();
                IState.Immutable newState = GreedySolver.this.state;
                for (ITermVar var : c.vars()) {
                    Tuple2<ITermVar, IState.Immutable> varAndState = newState.freshVar(var);
                    ITermVar freshVar = varAndState._1();
                    newState = varAndState._2();
                    _existentials.put(var, freshVar);
                }
                Renaming existentials = _existentials.build();
                ISubstitution.Immutable subst = existentials.asSubstitution();
                IConstraint newConstraint = c.constraint().apply(subst, true).withCause(c.cause().orElse(null));
                if (!c.bodyCriticalEdges().isPresent()) {
                    throw new IllegalArgumentException("Solver only accepts constraints with pre-computed critical edges.");
                }
                ICompleteness.Immutable newCriticalEdges = c.bodyCriticalEdges().orElse(Solver.NO_NEW_CRITICAL_EDGES).apply(subst);
                Map.Immutable<ITermVar, ITermVar> newExistentials = existentials.asMap();
                return CExistsStep.of(c, StepResult.success(newState).withNewConstraints(ImList.Immutable.of(new IConstraint[]{newConstraint})).withNewCriticalEdges(newCriticalEdges).withNewExistentials(newExistentials), newExistentials);
            }

            @Override
            public IStep caseFalse(CFalse c) {
                return CFalseStep.of(c, StepResult.failure());
            }

            @Override
            public IStep caseInequal(CInequal c) {
                ITerm term1 = c.term1();
                ITerm term2 = c.term2();
                IDebugContext debug = GreedySolver.this.params.debug();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                try {
                    IUniDisunifier.Result result = unifier.disunify((Iterable<ITermVar>)c.universals(), term1, term2, v -> GreedySolver.this.params.isRigid((ITermVar)v, GreedySolver.this.state)).orElse(null);
                    if (result != null) {
                        if (debug.isEnabled(Level.Debug)) {
                            debug.debug("Disunification succeeded: {}", result);
                        }
                        IState.Immutable newState = GreedySolver.this.state.withUnifier(result.unifier());
                        Set.Immutable<ITermVar> updatedVars = ((Optional)result.result()).map(Diseq::domainSet).orElse(Solver.NO_UPDATED_VARS);
                        return CInequalStep.of(c, StepResult.success(newState).withUpdatedVars(updatedVars), result);
                    }
                    debug.debug("Disunification failed", new Object[0]);
                    return CInequalStep.of(c, StepResult.failure(), null);
                }
                catch (RigidException e) {
                    return CInequalStep.of(c, StepResult.delay(Delay.ofVars(e.vars())), null);
                }
            }

            @Override
            public IStep caseNew(CNew c) {
                IState.Immutable newState = GreedySolver.this.state;
                ITerm scopeTerm = c.scopeTerm();
                String base = TermMatch.M.var(ITermVar::getName).match(scopeTerm).orElse("s");
                Tuple2<Scope, IState.Immutable> ss = newState.freshScope(base);
                Scope scope = ss._1();
                newState = ss._2();
                ITerm datumTerm = c.datumTerm();
                IScopeGraph.Immutable<Scope, ITerm, ITerm> newScopeGraph = GreedySolver.this.state.scopeGraph().setDatum(scope, datumTerm);
                newState = newState.withScopeGraph(newScopeGraph);
                CEqual eq = new CEqual(scopeTerm, (ITerm)scope, c);
                return CNewStep.of(c, StepResult.success(newState).withNewConstraints(ImList.Immutable.of(new IConstraint[]{eq})), scope, datumTerm);
            }

            @Override
            public IStep caseResolveQuery(IResolveQuery c) throws InterruptedException {
                QueryFilter filter = c.filter();
                QueryMin min2 = c.min();
                QueryProject project = c.project();
                ITerm scopeTerm = c.scopeTerm();
                ITerm resultTerm = c.resultTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                if (!unifier.isGround(scopeTerm)) {
                    return AResolveQueryStep.of(c, StepResult.delay(Delay.ofVars(unifier.getVars(scopeTerm))), null);
                }
                Set.Transient freeVarsBuilder = unifier.getVars(scopeTerm).asTransient();
                filter.getDataWF().freeVars().stream().map(v -> unifier.getVars((ITerm)v)).forEach(arg_0 -> ((Set.Transient)freeVarsBuilder).__insertAll(arg_0));
                min2.getDataEquiv().freeVars().stream().map(v -> unifier.getVars((ITerm)v)).forEach(arg_0 -> ((Set.Transient)freeVarsBuilder).__insertAll(arg_0));
                Set.Immutable freeVars = freeVarsBuilder.freeze();
                if (!freeVars.isEmpty()) {
                    return AResolveQueryStep.of(c, StepResult.delay(Delay.ofVars((Iterable<ITermVar>)freeVars)), null);
                }
                Rule dataWfRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(filter.getDataWF(), GreedySolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                Rule dataLeqRule = RuleUtil.instantiateHeadPatterns(RuleUtil.closeInUnifier(min2.getDataEquiv(), GreedySolver.this.state.unifier(), ApplyMode.Safety.UNSAFE));
                Scope scope = AScope.matcher().match(scopeTerm, unifier).orElse(null);
                if (scope == null) {
                    String scopeTermString = unifier.toString(scopeTerm);
                    GreedySolver.this.debug.error("Expected scope, got {}", scopeTermString);
                    return AResolveQueryStep.of(c, StepResult.failure(new IllegalStateException(String.valueOf(scopeTermString) + " is not a scope")), null);
                }
                try {
                    ConstraintQueries cq = new ConstraintQueries(GreedySolver.this.spec, GreedySolver.this.state, GreedySolver.this.params::isComplete);
                    Env paths = c.matchInResolution(resolveQuery -> {
                        INameResolution<Scope, ITerm, ITerm> nameResolution = Solver.nameResolutionBuilder().withLabelWF(cq.getLabelWF(filter.getLabelWF())).withDataWF(cq.getDataWF(dataWfRule)).withLabelOrder(cq.getLabelOrder(min2.getLabelOrder())).withDataEquiv(cq.getDataEquiv(dataLeqRule)).withIsComplete((s, l) -> GreedySolver.this.params.isComplete((Scope)s, (EdgeOrData<ITerm>)l, GreedySolver.this.state)).build(GreedySolver.this.state.scopeGraph(), (java.util.Set<ITerm>)GreedySolver.this.spec.allLabels());
                        return nameResolution.resolve(scope, GreedySolver.this.cancel);
                    }, compiledQuery -> {
                        ResolutionInterpreter<Scope, ITerm, ITerm> interpreter = new ResolutionInterpreter<Scope, ITerm, ITerm>((IScopeGraph.Immutable<Scope, ITerm, ITerm>)GreedySolver.this.state.scopeGraph(), cq.getDataWF(dataWfRule), cq.getDataEquiv(dataLeqRule), compiledQuery.stateMachine(), (Predicate2<Scope, EdgeOrData<ITerm>>)((Predicate2<Scope, EdgeOrData>)(s, l) -> GreedySolver.this.params.isComplete((Scope)s, (EdgeOrData<ITerm>)l, GreedySolver.this.state)));
                        return interpreter.resolve(scope, GreedySolver.this.cancel);
                    });
                    Collection<ITerm> pathTerms = paths.stream().map(p -> StatixTerms.pathToTerm(p, GreedySolver.this.spec.dataLabels())).map(p -> project.apply((ITerm)p).orElseThrow(() -> new IllegalStateException("Invalid resolution path: " + p))).collect(project.collector());
                    CEqual C2 = new CEqual(resultTerm, (ITerm)TermBuild.B.newList(pathTerms), c);
                    return AResolveQueryStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(ImList.Immutable.of(new IConstraint[]{C2})), paths);
                }
                catch (IncompleteException e) {
                    GreedySolver.this.params.debug().debug("Query resolution delayed: {}", e.getMessage());
                    return AResolveQueryStep.of(c, StepResult.delay(Delay.ofCriticalEdge(CriticalEdge.of((ITerm)e.scope(), e.label()))), null);
                }
                catch (ResolutionDelayException e) {
                    GreedySolver.this.params.debug().debug("Query resolution delayed: {}", e.getMessage());
                    return AResolveQueryStep.of(c, StepResult.delay(e.getCause()), null);
                }
                catch (ResolutionException e) {
                    GreedySolver.this.params.debug().debug("Query resolution failed: {}", e.getMessage());
                    return AResolveQueryStep.of(c, StepResult.failure(e), null);
                }
            }

            @Override
            public IStep caseTellEdge(CTellEdge c) {
                ITerm sourceTerm = c.sourceTerm();
                ITerm label = c.label();
                ITerm targetTerm = c.targetTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                Set.Transient freeVars = unifier.getVars(sourceTerm).asTransient();
                freeVars.__insertAll(unifier.getVars(targetTerm));
                if (!freeVars.isEmpty()) {
                    return CTellEdgeStep.of(c, StepResult.delay(Delay.ofVars((Iterable<ITermVar>)freeVars.freeze())), null, null);
                }
                Scope source = AScope.matcher().match(sourceTerm, unifier).orElse(null);
                if (source == null) {
                    String scopeTermString = unifier.toString(sourceTerm);
                    GreedySolver.this.debug.error("Expected source scope, got {}", scopeTermString);
                    return CTellEdgeStep.of(c, StepResult.failure(new IllegalStateException(String.valueOf(scopeTermString) + " is not a scope")), null, null);
                }
                if (GreedySolver.this.params.isClosed(source, GreedySolver.this.state)) {
                    return CTellEdgeStep.of(c, StepResult.failure(new IllegalStateException(source + " is closed")), null, null);
                }
                Scope target = AScope.matcher().match(targetTerm, unifier).orElse(null);
                if (target == null) {
                    String scopeTermString = unifier.toString(targetTerm);
                    GreedySolver.this.debug.error("Expected target scope, got {}", scopeTermString);
                    return CTellEdgeStep.of(c, StepResult.failure(new IllegalStateException(String.valueOf(scopeTermString) + " is not a scope")), null, null);
                }
                IScopeGraph.Immutable<Scope, ITerm, ITerm> scopeGraph = GreedySolver.this.state.scopeGraph().addEdge(source, label, target);
                IState.Immutable newState = GreedySolver.this.state.withScopeGraph(scopeGraph);
                return CTellEdgeStep.of(c, StepResult.success(newState), source, target);
            }

            @Override
            public IStep caseTermId(CAstId c) {
                AbstractApplTerm index;
                CEqual eq;
                ITerm term = c.astTerm();
                ITerm idTerm = c.idTerm();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                Set.Immutable<ITermVar> vars = unifier.getVars(term);
                if (!vars.isEmpty()) {
                    return CAstIdStep.of(c, StepResult.delay(Delay.ofVars(vars)), null);
                }
                Optional<Scope> maybeScope = AScope.matcher().match(term, unifier);
                if (maybeScope.isPresent()) {
                    AScope scope = maybeScope.get();
                    eq = new CEqual(idTerm, scope);
                    index = scope;
                } else {
                    Optional<TermIndex> maybeIndex = TermIndex.find(unifier.findTerm(term));
                    if (maybeIndex.isPresent()) {
                        TermIndex indexTerm = TermOrigin.copy(term, maybeIndex.get());
                        eq = new CEqual(idTerm, indexTerm);
                        index = indexTerm;
                    } else {
                        return CAstIdStep.of(c, StepResult.failure(), null);
                    }
                }
                return CAstIdStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(ImList.Immutable.of(new IConstraint[]{eq})), index);
            }

            @Override
            public IStep caseTermProperty(CAstProperty c) {
                ITerm idTerm = c.idTerm();
                ITerm prop = c.property();
                ITerm value = c.value();
                IUniDisunifier.Immutable unifier = GreedySolver.this.state.unifier();
                Set.Immutable<ITermVar> vars = unifier.getVars(idTerm);
                if (!vars.isEmpty()) {
                    return CAstPropertyStep.of(c, StepResult.delay(Delay.ofVars(vars)), null, null, null);
                }
                Optional<TermIndex> maybeIndex = TermIndex.matcher().match(idTerm, unifier);
                if (maybeIndex.isPresent()) {
                    ITermProperty property;
                    TermIndex index = maybeIndex.get();
                    Tuple2<TermIndex, ITerm> key = Tuple2.of(index, prop);
                    switch (c.op()) {
                        case ADD: {
                            property = (ITermProperty)GreedySolver.this.state.termProperties().getOrDefault(key, (Object)BagTermProperty.of());
                            if (!property.multiplicity().equals((Object)ITermProperty.Multiplicity.BAG)) {
                                return CAstPropertyStep.of(c, StepResult.failure(), null, null, null);
                            }
                            property = property.addValue(value);
                            break;
                        }
                        case SET: {
                            if (GreedySolver.this.state.termProperties().containsKey(key)) {
                                ITerm newVal;
                                ITermProperty property2 = (ITermProperty)GreedySolver.this.state.termProperties().get(key);
                                if (!property2.multiplicity().equals((Object)ITermProperty.Multiplicity.SINGLETON)) {
                                    return CAstPropertyStep.of(c, StepResult.failure(), null, null, null);
                                }
                                ITerm propVal = unifier.findRecursive(property2.value());
                                if (propVal.equals(newVal = unifier.findRecursive(value)) && propVal.getAttachments().equals(newVal.getAttachments())) {
                                    return CAstPropertyStep.of(c, StepResult.success(GreedySolver.this.state), index, property2, newVal).withUpdate(false);
                                }
                                return CAstPropertyStep.of(c, StepResult.failure(), null, null, null);
                            }
                            property = SingletonTermProperty.of(value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown op " + (Object)((Object)c.op()));
                        }
                    }
                    IState.Immutable newState = GreedySolver.this.state.withTermProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)GreedySolver.this.state.termProperties().__put(key, (Object)property));
                    return CAstPropertyStep.of(c, StepResult.success(newState), index, property, value);
                }
                return CAstPropertyStep.of(c, StepResult.failure(), null, null, null);
            }

            @Override
            public IStep caseTrue(CTrue c) {
                return CTrueStep.of(c, StepResult.success(GreedySolver.this.state));
            }

            @Override
            public IStep caseTry(CTry c) throws InterruptedException {
                IDebugContext debug = GreedySolver.this.params.debug();
                try {
                    if (Solver.entails(GreedySolver.this.spec, GreedySolver.this.state, c.constraint(), GreedySolver.this.params::isComplete, new NullDebugContext(), GreedySolver.this.progress.subProgress(1), GreedySolver.this.cancel)) {
                        return CTryStep.of(c, StepResult.success(GreedySolver.this.state));
                    }
                    return CTryStep.of(c, StepResult.failure());
                }
                catch (Delay delay) {
                    debug.debug("Try delayed: {}", delay.getMessage());
                    return CTryStep.of(c, StepResult.delay(delay));
                }
            }

            @Override
            public IStep caseUser(CUser c) {
                String name = c.name();
                List<ITerm> args = c.args();
                LazyDebugContext proxyDebug = new LazyDebugContext(GreedySolver.this.debug);
                IDebugContext debug = GreedySolver.this.params.debug();
                ImList.Immutable<Rule> rules = GreedySolver.this.spec.rules().getRules(name);
                Tuple3 result = RuleUtil.applyOrderedOne(GreedySolver.this.state.unifier(), rules, args, c, ApplyMode.RELAXED, ApplyMode.Safety.UNSAFE, true).orElse(null);
                if (result == null) {
                    debug.debug("No rule applies", new Object[0]);
                    return CUserStep.of(c, StepResult.failure(), null, null, false);
                }
                ApplyResult applyResult = (ApplyResult)result._2();
                if (!((Boolean)result._3()).booleanValue()) {
                    Set stuckVars = (Set)applyResult.guard().map(Diseq::domainSet).orElse(CapsuleUtil.immutableSet());
                    proxyDebug.debug("Rule delayed (multiple conditional matches)", new Object[0]);
                    return CUserStep.of(c, StepResult.delay(Delay.ofVars((Iterable<ITermVar>)stuckVars)), applyResult, (Rule)result._1(), (Boolean)result._3());
                }
                proxyDebug.debug("Rule accepted", new Object[0]);
                proxyDebug.commit();
                if (applyResult.criticalEdges() == null) {
                    throw new IllegalArgumentException("Solver only accepts specs with pre-computed critical edges.");
                }
                return CUserStep.of(c, StepResult.success(GreedySolver.this.state).withNewConstraints(Collections.singletonList(applyResult.body())).withNewCriticalEdges(applyResult.criticalEdges()), applyResult, (Rule)result._1(), (Boolean)result._3());
            }
        });
    }
}

