/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.log;

import java.util.Collections;
import mb.statix.solver.log.IDebugContext;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.Level;

public class LoggerDebugContext
implements IDebugContext {
    private final ILogger logger;
    private final Level debugLevel;
    private final int depth;
    private volatile IDebugContext subContext;

    public LoggerDebugContext(ILogger logger) {
        this(logger, Level.Info, 0);
    }

    public LoggerDebugContext(ILogger logger, Level debugLevel) {
        this(logger, debugLevel, 0);
    }

    private LoggerDebugContext(ILogger logger, Level debugLevel, int depth) {
        this.logger = logger;
        this.debugLevel = debugLevel;
        this.depth = depth;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public boolean isEnabled(Level level) {
        return this.logger.enabled(level);
    }

    @Override
    public Level getDebugLevel() {
        return this.debugLevel;
    }

    @Override
    public IDebugContext subContext() {
        IDebugContext result = this.subContext;
        if (result == null) {
            this.subContext = result = new LoggerDebugContext(this.logger, this.debugLevel, this.depth + 1);
        }
        return result;
    }

    @Override
    public void debug(String fmt, Object ... args) {
        if (this.isEnabled(this.getDebugLevel())) {
            this.logger.log(this.getDebugLevel(), String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void debug(String fmt, Throwable t, Object ... args) {
        if (this.isEnabled(this.getDebugLevel())) {
            this.logger.log(this.getDebugLevel(), String.valueOf(this.prefix()) + fmt, t, args);
        }
    }

    @Override
    public void warn(String fmt, Object ... args) {
        if (this.isEnabled(Level.Warn)) {
            this.logger.warn(String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void warn(String fmt, Throwable t, Object ... args) {
        if (this.isEnabled(Level.Warn)) {
            this.logger.warn(String.valueOf(this.prefix()) + fmt, t, args);
        }
    }

    @Override
    public void error(String fmt, Object ... args) {
        if (this.isEnabled(Level.Error)) {
            this.logger.error(String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void error(String fmt, Throwable t, Object ... args) {
        if (this.isEnabled(Level.Error)) {
            this.logger.error(String.valueOf(this.prefix()) + fmt, t, args);
        }
    }

    @Override
    public void log(Level level, String fmt, Object ... args) {
        if (this.isEnabled(level)) {
            this.logger.log(level, String.valueOf(this.prefix()) + fmt, args);
        }
    }

    @Override
    public void log(Level level, String fmt, Throwable t, Object ... args) {
        if (this.isEnabled(level)) {
            this.logger.log(level, String.valueOf(this.prefix()) + fmt, t, args);
        }
    }

    private String prefix() {
        return String.join((CharSequence)"", Collections.nCopies(this.depth, "| "));
    }
}

