/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.solver.completeness;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.SetMultimap;
import java.util.Collection;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.u.IUnifier;
import mb.nabl2.terms.unification.ud.PersistentUniDisunifier;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.constraints.CCompiledQuery;
import mb.statix.constraints.CResolveQuery;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.IResolveQuery;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.query.QueryFilter;
import mb.statix.solver.query.QueryMin;
import mb.statix.spec.Rule;
import mb.statix.spec.Spec;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Action2;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public class CompletenessUtil {
    static void criticalEdges(IConstraint constraint, Spec spec, Action2<ITerm, EdgeOrData<ITerm>> criticalEdge) {
        constraint.match(Constraints.cases(onArith -> Unit.unit, onConj -> {
            Constraints.disjoin(onConj).forEach(c -> CompletenessUtil.criticalEdges(c, spec, criticalEdge));
            return Unit.unit;
        }, onEqual -> Unit.unit, onExists -> {
            CompletenessUtil.criticalEdges(onExists.constraint(), spec, (ITerm s, EdgeOrData<ITerm> l) -> {
                if (!onExists.vars().contains(s)) {
                    criticalEdge.apply((ITerm)s, (EdgeOrData<ITerm>)l);
                }
            });
            return Unit.unit;
        }, onFalse -> Unit.unit, onInequal -> Unit.unit, onNew -> {
            criticalEdge.apply(onNew.scopeTerm(), EdgeOrData.data());
            return Unit.unit;
        }, onResolveQuery -> Unit.unit, onTellEdge -> {
            criticalEdge.apply(onTellEdge.sourceTerm(), EdgeOrData.edge(onTellEdge.label()));
            return Unit.unit;
        }, onTermId -> Unit.unit, onTermProperty -> Unit.unit, onTrue -> Unit.unit, onTry -> Unit.unit, onUser -> {
            spec.scopeExtensions().get((Object)onUser.name()).forEach(il -> criticalEdge.apply(onUser.args().get((Integer)il._1()), EdgeOrData.edge((ITerm)il._2())));
            return Unit.unit;
        }));
    }

    public static Collection<CriticalEdge> criticalEdges(IConstraint constraint, Spec spec) {
        ImList.Mutable<CriticalEdge> criticalEdges = ImList.Mutable.of(new CriticalEdge[0]);
        CompletenessUtil.criticalEdges(constraint, spec, (ITerm s, EdgeOrData<ITerm> l) -> {
            boolean bl = criticalEdges.add(CriticalEdge.of(s, l));
        });
        return criticalEdges.freeze();
    }

    public static Collection<CriticalEdge> criticalEdges(IConstraint constraint, Spec spec, IUnifier unifier) {
        ImList.Mutable<CriticalEdge> criticalEdges = ImList.Mutable.of(new CriticalEdge[0]);
        CompletenessUtil.criticalEdges(constraint, spec, (ITerm s, EdgeOrData<ITerm> l) -> CompletenessUtil.scopeOrVar().match((ITerm)s, unifier).ifPresent(scopeOrVar -> criticalEdges.add(CriticalEdge.of(scopeOrVar, l))));
        return criticalEdges.freeze();
    }

    public static TermMatch.IMatcher<ITerm> scopeOrVar() {
        return TermMatch.M.cases(Scope.matcher(), TermMatch.M.var());
    }

    public static Rule precomputeCriticalEdges(Rule rule, SetMultimap<String, Tuple2<Integer, ITerm>> spec) {
        return CompletenessUtil.precomputeCriticalEdges(rule, spec, (ITerm s, EdgeOrData<ITerm> l) -> {
            throw new IllegalArgumentException("Rule cannot have escaping critical edges.");
        });
    }

    public static Tuple2<IConstraint, ICompleteness.Immutable> precomputeCriticalEdges(IConstraint constraint, SetMultimap<String, Tuple2<Integer, ITerm>> spec) {
        Completeness.Transient criticalEdges = Completeness.Transient.of();
        IConstraint newConstraint = CompletenessUtil.precomputeCriticalEdges(constraint, spec, (ITerm s, EdgeOrData<ITerm> l) -> criticalEdges.add((ITerm)s, (EdgeOrData<ITerm>)l, (IUnifier)PersistentUniDisunifier.Immutable.of()));
        return Tuple2.of(newConstraint, criticalEdges.freeze());
    }

    static Rule precomputeCriticalEdges(Rule rule, SetMultimap<String, Tuple2<Integer, ITerm>> spec, Action2<ITerm, EdgeOrData<ITerm>> criticalEdge) {
        Set.Immutable<ITermVar> paramVars = rule.paramVars();
        Completeness.Transient criticalEdges = Completeness.Transient.of();
        IConstraint newBody = CompletenessUtil.precomputeCriticalEdges(rule.body(), spec, (ITerm s, EdgeOrData<ITerm> l) -> {
            if (paramVars.contains(s)) {
                criticalEdges.add((ITerm)s, (EdgeOrData<ITerm>)l, (IUnifier)PersistentUniDisunifier.Immutable.of());
            } else {
                criticalEdge.apply((ITerm)s, (EdgeOrData<ITerm>)l);
            }
        });
        return rule.withBody(newBody).withBodyCriticalEdges(criticalEdges.freeze());
    }

    static IConstraint precomputeCriticalEdges(IConstraint constraint, SetMultimap<String, Tuple2<Integer, ITerm>> spec, Action2<ITerm, EdgeOrData<ITerm>> criticalEdge) {
        return constraint.match(Constraints.cases(carith -> carith, cconj -> {
            IConstraint newLeft = CompletenessUtil.precomputeCriticalEdges(cconj.left(), spec, criticalEdge);
            IConstraint newRight = CompletenessUtil.precomputeCriticalEdges(cconj.right(), spec, criticalEdge);
            return cconj.withArguments(newLeft, newRight);
        }, cequal -> cequal, cexists -> {
            Completeness.Transient bodyCriticalEdges = Completeness.Transient.of();
            IConstraint newBody = CompletenessUtil.precomputeCriticalEdges(cexists.constraint(), spec, (ITerm s, EdgeOrData<ITerm> l) -> {
                if (cexists.vars().contains(s)) {
                    bodyCriticalEdges.add((ITerm)s, (EdgeOrData<ITerm>)l, (IUnifier)PersistentUniDisunifier.Immutable.of());
                } else {
                    criticalEdge.apply((ITerm)s, (EdgeOrData<ITerm>)l);
                }
            });
            return cexists.withArguments((Iterable<ITermVar>)cexists.vars(), newBody).withBodyCriticalEdges(bodyCriticalEdges.freeze());
        }, cfalse -> cfalse, cinequal -> cinequal, cnew -> {
            Completeness.Transient ownCriticalEdges = Completeness.Transient.of();
            ITerm scopeOrVar = CompletenessUtil.scopeOrVar().match(cnew.scopeTerm()).orElse(null);
            if (scopeOrVar != null) {
                ownCriticalEdges.add(scopeOrVar, EdgeOrData.data(), (IUnifier)PersistentUniDisunifier.Immutable.of());
                criticalEdge.apply(scopeOrVar, EdgeOrData.data());
            }
            return cnew.withArguments(cnew.scopeTerm(), cnew.datumTerm()).withOwnCriticalEdges(ownCriticalEdges.freeze());
        }, iresolveQuery -> {
            final QueryFilter newFilter = new QueryFilter(iresolveQuery.filter().getLabelWF(), CompletenessUtil.precomputeCriticalEdges(iresolveQuery.filter().getDataWF(), spec));
            final QueryMin newMin = new QueryMin(iresolveQuery.min().getLabelOrder(), CompletenessUtil.precomputeCriticalEdges(iresolveQuery.min().getDataEquiv(), spec));
            return iresolveQuery.match(new IResolveQuery.Cases<IResolveQuery>(){

                @Override
                public IResolveQuery caseResolveQuery(CResolveQuery q) {
                    return q.withArguments(newFilter, newMin, q.project(), q.scopeTerm(), q.resultTerm());
                }

                @Override
                public IResolveQuery caseCompiledQuery(CCompiledQuery q) {
                    return q.withArguments(newFilter, newMin, q.project(), q.scopeTerm(), q.resultTerm(), q.stateMachine());
                }
            });
        }, ctellEdge -> {
            Completeness.Transient ownCriticalEdges = Completeness.Transient.of();
            ITerm scopeOrVar = CompletenessUtil.scopeOrVar().match(ctellEdge.sourceTerm()).orElse(null);
            if (scopeOrVar != null) {
                ownCriticalEdges.add(scopeOrVar, EdgeOrData.edge(ctellEdge.label()), (IUnifier)PersistentUniDisunifier.Immutable.of());
                criticalEdge.apply(scopeOrVar, EdgeOrData.edge(ctellEdge.label()));
            }
            return ctellEdge.withArguments(ctellEdge.sourceTerm(), ctellEdge.label(), ctellEdge.targetTerm()).withOwnCriticalEdges(ownCriticalEdges.freeze());
        }, ctermId -> ctermId, ctermProperty -> ctermProperty, ctrue -> ctrue, ctry -> {
            IConstraint newBody = CompletenessUtil.precomputeCriticalEdges(ctry.constraint(), spec, criticalEdge);
            return ctry.withArguments(newBody);
        }, cuser -> {
            Completeness.Transient ownCriticalEdges = Completeness.Transient.of();
            spec.get((Object)cuser.name()).forEach(il -> {
                ITerm scopeOrVar = CompletenessUtil.scopeOrVar().match(cuser.args().get((Integer)il._1())).orElse(null);
                if (scopeOrVar != null) {
                    EdgeOrData<ITerm> label = EdgeOrData.edge((ITerm)il._2());
                    ownCriticalEdges.add(scopeOrVar, label, (IUnifier)PersistentUniDisunifier.Immutable.of());
                    criticalEdge.apply(scopeOrVar, label);
                }
            });
            return cuser.withArguments(cuser.name(), cuser.args()).withOwnCriticalEdges(ownCriticalEdges.freeze());
        }));
    }
}

