/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints.messages;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.substitution.PersistentSubstitution;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.scopegraph.oopsla20.reference.EdgeOrData;
import mb.statix.constraints.CAstId;
import mb.statix.constraints.CAstProperty;
import mb.statix.constraints.Constraints;
import mb.statix.constraints.messages.IMessage;
import mb.statix.constraints.messages.Message;
import mb.statix.constraints.messages.MessageKind;
import mb.statix.solver.ACriticalEdge;
import mb.statix.solver.CriticalEdge;
import mb.statix.solver.Delay;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spoofax.IStatixProjectConfig;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.stream.StreamUtil;
import org.metaborg.util.tuple.Tuple2;

public class MessageUtil {
    private static final Map<Class<? extends IConstraint>, MessageKind> KINDS = Map.Immutable.of(CAstId.class, (Object)MessageKind.IGNORE, CAstProperty.class, (Object)MessageKind.IGNORE);

    public static IMessage findClosestMessage(IConstraint c) {
        return MessageUtil.findClosestMessage(c, KINDS.getOrDefault(c.getClass(), null));
    }

    public static IMessage findClosestMessage(IConstraint c, @Nullable MessageKind kind) {
        IMessage message = null;
        while (c != null) {
            IMessage m = c.message().orElse(null);
            if (m != null && (message == null || message.kind().isWorseThan(m.kind()))) {
                message = m;
            }
            c = c.cause().orElse(null);
        }
        if (message == null) {
            message = kind == null ? new Message(MessageKind.ERROR) : new Message(kind);
        } else if (kind != null) {
            message = message.withKind(kind);
        }
        return message;
    }

    public static <TR extends SolverTracer.IResult<TR>> SolverResult<TR> delaysAsErrors(SolverResult<TR> result, boolean suppressCascadingErrors) {
        Map.Immutable delays;
        block5: {
            Set.Immutable newErrorVars;
            delays = result.delays();
            if (!suppressCascadingErrors) break block5;
            IUniDisunifier.Immutable unifier = result.state().unifier();
            Set.Immutable allErrorVars = newErrorVars = (Set.Immutable)result.messages().entrySet().stream().filter(e -> ((IMessage)e.getValue()).kind().equals(MessageKind.ERROR)).map(Map.Entry::getKey).flatMap(c -> c.freeVars().stream()).flatMap(v -> unifier.findRecursive((ITerm)v).getVars().stream()).collect(CapsuleCollectors.toSet());
            Set.Immutable newCriticalEdges = CapsuleUtil.immutableSet();
            Set.Immutable allCriticalEdges = CapsuleUtil.immutableSet();
            while (!newErrorVars.isEmpty() || !newCriticalEdges.isEmpty()) {
                Set.Transient _newVars = CapsuleUtil.transientSet();
                Set.Transient _newCriticalEdges = CapsuleUtil.transientSet();
                Map.Transient retainedDelays = CapsuleUtil.transientMap();
                for (Map.Entry e2 : delays.entrySet()) {
                    block7: {
                        block6: {
                            Delay d2 = (Delay)e2.getValue();
                            if (d2.vars().stream().anyMatch(arg_0 -> ((Set.Immutable)newErrorVars).contains(arg_0))) break block6;
                            if (!d2.criticalEdges().stream().anyMatch(arg_0 -> ((Set.Immutable)newCriticalEdges).contains(arg_0))) break block7;
                        }
                        for (ITermVar var : ((IConstraint)e2.getKey()).freeVars()) {
                            _newVars.__insertAll((Set)unifier.findRecursive(var).getVars().__removeAll((Set)allErrorVars));
                        }
                        for (Map.Entry<ITerm, MultiSet.Immutable<EdgeOrData<ITerm>>> criticalEdges : ((IConstraint)e2.getKey()).ownCriticalEdges().orElse(Completeness.Immutable.of()).entrySet()) {
                            ITerm scope = unifier.findRecursive(criticalEdges.getKey());
                            Set.Immutable edges = (Set.Immutable)criticalEdges.getValue().elementSet().stream().map(edge -> CriticalEdge.of(scope, edge)).collect(CapsuleCollectors.toSet());
                            _newCriticalEdges.__insertAll((Set)edges.__removeAll((Set)allCriticalEdges));
                        }
                        continue;
                    }
                    retainedDelays.__put((Object)((IConstraint)e2.getKey()), (Object)((Delay)e2.getValue()));
                }
                delays = retainedDelays.freeze();
                newErrorVars = _newVars.freeze();
                allErrorVars = allErrorVars.__insertAll((Set)newErrorVars);
                newCriticalEdges = _newCriticalEdges.freeze();
                allCriticalEdges = allCriticalEdges.__insertAll((Set)newCriticalEdges);
            }
        }
        Map.Transient messages = CapsuleUtil.transientMap();
        messages.__putAll(result.messages());
        delays.forEach((c, d) -> {
            Object object = messages.__put(c, (Object)new Unsolved(MessageUtil.findClosestMessage(c), (Delay)d, c.ownCriticalEdges().orElse(null)));
        });
        return result.withMessages((Map.Immutable<IConstraint, IMessage>)messages.freeze()).withDelays(CapsuleUtil.immutableMap());
    }

    public static void addMessage(IMessage message, IConstraint constraint, IUniDisunifier unifier, IStatixProjectConfig config, Collection<ITerm> errors, Collection<ITerm> warnings, Collection<ITerm> notes) {
        Tuple2<Collection<String>, ITerm> message_origin = MessageUtil.formatMessage(message, constraint, unifier, config);
        String messageText = message_origin._1().stream().filter(s -> !s.isEmpty()).map(s -> MessageUtil.cleanupString(s)).collect(Collectors.joining("<br>\n&gt;&nbsp;", "", "<br>\n"));
        ITerm messageTerm = TermBuild.B.newTuple(message_origin._2(), TermBuild.B.newString(messageText));
        switch (message.kind()) {
            case ERROR: {
                errors.add(messageTerm);
                break;
            }
            case WARNING: {
                warnings.add(messageTerm);
                break;
            }
            case NOTE: {
                notes.add(messageTerm);
                break;
            }
        }
    }

    public static Tuple2<Collection<String>, ITerm> formatMessage(IMessage message, IConstraint constraint, IUniDisunifier unifier, IStatixProjectConfig config) {
        TermFormatter formatter = Solver.shallowTermFormatter(unifier, config.messageTermDepth(config.messageTermDepth(3)));
        int maxTraceLength = config.messageTraceLength(config.messageTraceLength(0));
        ITerm originTerm = message.origin().flatMap(t -> MessageUtil.getOriginTerm(t, unifier)).orElse(MessageUtil.findOrigin(constraint, unifier));
        Deque<String> trace = MessageUtil.formatTrace(constraint, unifier, formatter, maxTraceLength);
        trace.addFirst(message.toString(formatter, () -> constraint.toString(formatter), completeness -> {
            ISubstitution.Transient subst = PersistentSubstitution.Transient.of();
            completeness.vars().forEach(var -> {
                ITerm sub = unifier.findRecursive((ITerm)var);
                if (!sub.equals(var)) {
                    subst.put((ITermVar)var, sub);
                }
            });
            return completeness.apply(subst.freeze()).entrySet().stream().flatMap(e -> {
                String scope = ((ITerm)e.getKey()).toString();
                return ((MultiSet.Immutable)e.getValue()).elementSet().stream().map(edge -> String.valueOf(scope) + "-" + edge.toString());
            }).collect(Collectors.joining(", "));
        }));
        if (originTerm == null) {
            originTerm = TermBuild.B.newTuple(new ITerm[0]);
        }
        return Tuple2.of(trace, originTerm);
    }

    private static ITerm findOrigin(IConstraint constraint, IUniDisunifier unifier) {
        while (constraint != null) {
            ITerm origin = MessageUtil.findOriginArgument(constraint, unifier).orElse(null);
            if (origin != null) {
                return origin;
            }
            constraint = constraint.cause().orElse(null);
        }
        return null;
    }

    public static Deque<String> formatTrace(IConstraint constraint, IUniDisunifier unifier, TermFormatter formatter, int maxTraceLength) {
        ArrayDeque<String> trace = new ArrayDeque<String>();
        IConstraint current = constraint;
        int traceCount = 0;
        while (current != null) {
            if (maxTraceLength < 0 || ++traceCount <= maxTraceLength) {
                trace.addLast(current.toString(formatter));
            }
            current = current.cause().orElse(null);
        }
        if (maxTraceLength > 0 && traceCount > maxTraceLength) {
            trace.addLast("... trace truncated ...");
        }
        return trace;
    }

    private static Optional<ITerm> findOriginArgument(IConstraint constraint, IUniDisunifier unifier) {
        IConstraint.Cases<Stream> terms = Constraints.cases(onArith -> Stream.empty(), onConj -> Stream.empty(), onEqual -> Stream.empty(), onExists -> Stream.empty(), onFalse -> Stream.empty(), onInequal -> Stream.empty(), onNew -> Stream.empty(), onResolveQuery -> Stream.empty(), onTellEdge -> Stream.empty(), onTermId -> Stream.empty(), onTermProperty -> Stream.empty(), onTrue -> Stream.empty(), onTry -> Stream.empty(), onUser -> onUser.args().stream());
        return StreamUtil.filterMap((Stream)terms.apply(constraint), t -> MessageUtil.getOriginTerm(t, unifier)).findFirst();
    }

    private static Optional<ITerm> getOriginTerm(ITerm term, IUniDisunifier unifier) {
        return Optional.of(unifier.findTerm(term)).filter(t -> TermIndex.get(t).isPresent()).filter(t -> TermOrigin.get(t).isPresent()).map(t -> TermBuild.B.newTuple(ImList.Immutable.of(new ITerm[0]), t.getAttachments()));
    }

    private static String cleanupString(String string) {
        return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\r\n", "<br>").replace("\n", "<br>").replace("\r", "<br>").replace("\t", "&Tab;");
    }

    private static class Unsolved
    implements IMessage,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final IMessage message;
        private final Delay delay;
        @Nullable
        private final ICompleteness.Immutable completeness;

        private Unsolved(IMessage message, Delay delay, @Nullable ICompleteness.Immutable completeness) {
            this.message = message;
            this.delay = delay;
            this.completeness = completeness;
        }

        @Override
        public MessageKind kind() {
            return this.message.kind();
        }

        @Override
        public String toString(TermFormatter formatter, Function0<String> getDefaultMessage, Function1<ICompleteness.Immutable, String> formatCompleteness) {
            StringBuilder sb = new StringBuilder("(unsolved)");
            String msg = this.message.toString(formatter, getDefaultMessage, formatCompleteness);
            if (!msg.isEmpty()) {
                sb.append(" ");
                sb.append(msg);
                sb.append(":");
            }
            sb.append(" delayed on");
            boolean first = true;
            if (!this.delay.vars().isEmpty()) {
                sb.append(" vars: ").append(this.delay.vars().stream().map(Object::toString).collect(Collectors.joining(", ")));
                first = false;
            }
            if (!this.delay.criticalEdges().isEmpty()) {
                if (!first) {
                    sb.append(" and");
                }
                sb.append(" critial edges: ").append(this.delay.criticalEdges().stream().map(ACriticalEdge::toString).collect(Collectors.joining(", ")));
                first = false;
            }
            if (this.completeness != null && !this.completeness.isEmpty()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(" preventing completion of ").append(formatCompleteness.apply(this.completeness));
            }
            return sb.toString();
        }

        @Override
        public Optional<ITerm> origin() {
            return this.message.origin();
        }

        @Override
        public void visitVars(Action1<ITermVar> onVar) {
            this.message.visitVars(onVar);
        }

        @Override
        public IMessage apply(ISubstitution.Immutable subst) {
            return new Unsolved(this.message.apply(subst), this.delay, this.completeness == null ? null : this.completeness.apply(subst));
        }

        @Override
        public IMessage apply(IRenaming subst) {
            return new Unsolved(this.message.apply(subst), this.delay, this.completeness == null ? null : this.completeness.apply(subst));
        }

        @Override
        public IMessage withKind(MessageKind kind) {
            return new Unsolved(this.message.withKind(kind), this.delay, this.completeness);
        }
    }
}

