/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.constraints.messages.IMessage;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.functions.Action1;

public final class CUser
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ITerm> args;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final IMessage message;
    @Nullable
    private final CUser origin;
    @Nullable
    private final ICompleteness.Immutable ownCriticalEdges;
    private final int hashCode = this.computeHashCode();

    public CUser(String name, Iterable<? extends ITerm> args) {
        this(name, args, null, null, null, null);
    }

    public CUser(String name, Iterable<? extends ITerm> args, @Nullable IMessage message) {
        this(name, args, null, message, null, null);
    }

    private CUser(String name, Iterable<? extends ITerm> args, @Nullable IConstraint cause, @Nullable IMessage message, @Nullable CUser origin, @Nullable ICompleteness.Immutable ownCriticalEdges) {
        this.name = name;
        this.args = ImList.Immutable.copyOf(args);
        this.cause = cause;
        this.message = message;
        this.origin = origin;
        this.ownCriticalEdges = ownCriticalEdges;
    }

    public String name() {
        return this.name;
    }

    public List<ITerm> args() {
        return this.args;
    }

    public CUser withArguments(String name, Iterable<? extends ITerm> args) {
        if (this.name == name && this.args == args) {
            return this;
        }
        return new CUser(name, args, this.cause, this.message, this.origin, this.ownCriticalEdges);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CUser withCause(@Nullable IConstraint cause) {
        if (this.cause == cause) {
            return this;
        }
        return new CUser(this.name, this.args, cause, this.message, this.origin, this.ownCriticalEdges);
    }

    @Override
    public Optional<IMessage> message() {
        return Optional.ofNullable(this.message);
    }

    @Override
    public CUser withMessage(@Nullable IMessage message) {
        if (this.message == message) {
            return this;
        }
        return new CUser(this.name, this.args, this.cause, message, this.origin, this.ownCriticalEdges);
    }

    @Override
    @Nullable
    public CUser origin() {
        return this.origin;
    }

    @Override
    public Optional<ICompleteness.Immutable> ownCriticalEdges() {
        return Optional.ofNullable(this.ownCriticalEdges);
    }

    @Override
    public CUser withOwnCriticalEdges(ICompleteness.Immutable criticalEdges) {
        if (this.ownCriticalEdges == criticalEdges) {
            return this;
        }
        return new CUser(this.name, this.args, this.cause, this.message, this.origin, criticalEdges);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseUser(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseUser(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        Set.Transient vars = CapsuleUtil.transientSet();
        for (ITerm a : this.args) {
            vars.__insertAll(a.getVars());
        }
        return vars.freeze();
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Transient freeVars = CapsuleUtil.transientSet();
        this.doVisitFreeVars(arg_0 -> freeVars.__insert(arg_0));
        return freeVars.freeze();
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.doVisitFreeVars(onFreeVar);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.args.forEach(t -> t.getVars().forEach(onFreeVar::apply));
        if (this.message != null) {
            this.message.visitVars(onFreeVar);
        }
    }

    @Override
    public CUser apply(ISubstitution.Immutable subst) {
        return this.apply(subst, false);
    }

    @Override
    public CUser unsafeApply(ISubstitution.Immutable subst) {
        return this.unsafeApply(subst, false);
    }

    @Override
    public CUser apply(IRenaming subst) {
        return this.apply(subst, false);
    }

    @Override
    public CUser apply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public CUser unsafeApply(ISubstitution.Immutable subst, boolean trackOrigin) {
        return this.apply(subst, trackOrigin);
    }

    @Override
    public CUser apply(IRenaming subst, boolean trackOrigin) {
        return new CUser(this.name, subst.apply(this.args), this.cause, this.message == null ? null : this.message.apply(subst), this.origin == null && trackOrigin ? this : this.origin, this.ownCriticalEdges == null ? null : this.ownCriticalEdges.apply(subst));
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        sb.append(termToString.format(this.args));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CUser that = (CUser)o;
        return this.hashCode == that.hashCode && Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args) && Objects.equals(this.cause, that.cause) && Objects.equals(this.message, that.message) && Objects.equals(this.origin, that.origin);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return Objects.hash(this.name, this.args, this.cause, this.message, this.origin);
    }
}

