/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent.util;

import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.Collection;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.unification.u.IUnifier;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.SetMultimap;

public class VarIndexedCollection<V> {
    private final SetMultimap<ITermVar, Entry> index = new SetMultimap();

    public boolean put(V value, Collection<ITermVar> indexVars, IUnifier unifier) {
        io.usethesource.capsule.Set vars = (io.usethesource.capsule.Set)indexVars.stream().flatMap(v -> unifier.getVars((ITerm)v).stream()).collect(CapsuleCollectors.toSet());
        Entry entry = new Entry(value);
        for (ITermVar var : vars) {
            this.index.put(var, entry.inc());
        }
        return !vars.isEmpty();
    }

    public Set.Immutable<V> update(Iterable<ITermVar> indexVars, IUnifier unifier) {
        Set.Transient done = CapsuleUtil.transientSet();
        for (ITermVar indexVar : indexVars) {
            this.update(indexVar, unifier, done);
        }
        return done.freeze();
    }

    public Set.Immutable<V> update(ITermVar indexVar, IUnifier unifier) {
        Set.Transient done = CapsuleUtil.transientSet();
        this.update(indexVar, unifier, done);
        return done.freeze();
    }

    private void update(ITermVar indexVar, IUnifier unifier, Set.Transient<V> done) {
        Set.Immutable<ITermVar> vars = unifier.getVars(indexVar);
        Set<Entry> entries = this.index.remove(indexVar);
        for (Entry entry : entries) {
            entry.dec();
            for (ITermVar var : vars) {
                this.index.put(var, entry.inc());
            }
            if (entry.refcount() != 0) continue;
            done.__insert(entry.value);
        }
    }

    public class Entry {
        private final V value;
        private int refcount;

        public Entry(V value) {
            this.value = value;
            this.refcount = 0;
        }

        public V value() {
            return this.value;
        }

        public int refcount() {
            return this.refcount;
        }

        public Entry dec() {
            --this.refcount;
            return this;
        }

        public Entry inc() {
            ++this.refcount;
            return this;
        }
    }
}

