/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import mb.statix.concurrent.AStatixUnit;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.spec.Rule;

public final class StatixUnit
extends AStatixUnit {
    private final String resource;
    private final Rule rule;
    private final boolean changed;
    private transient int hashCode;

    private StatixUnit(String resource, Optional<? extends Rule> rule, boolean changed) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.rule = rule.orElse(null);
        this.changed = changed;
    }

    private StatixUnit(StatixUnit original, String resource, Rule rule, boolean changed) {
        this.resource = resource;
        this.rule = rule;
        this.changed = changed;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    public final StatixUnit withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixUnit(this, newValue, this.rule, this.changed);
    }

    public final StatixUnit withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixUnit(this, this.resource, newValue, this.changed);
    }

    public final StatixUnit withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixUnit(this, this.resource, value, this.changed);
    }

    public final StatixUnit withChanged(boolean value) {
        if (this.changed == value) {
            return this;
        }
        return new StatixUnit(this, this.resource, this.rule, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixUnit && this.equalTo(0, (StatixUnit)another);
    }

    private boolean equalTo(int synthetic, StatixUnit another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.rule, another.rule) && this.changed == another.changed;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + Boolean.hashCode(this.changed);
        return h;
    }

    public static StatixUnit of(String resource, Optional<? extends Rule> rule, boolean changed) {
        return new StatixUnit(resource, rule, changed);
    }

    public static StatixUnit copyOf(AStatixUnit instance) {
        if (instance instanceof StatixUnit) {
            return (StatixUnit)instance;
        }
        return StatixUnit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixUnit(StatixUnit statixUnit, String string, Rule rule, boolean bl, StatixUnit statixUnit2) {
        this(statixUnit, string, rule, bl);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_CHANGED = 2L;
        private long initBits = 3L;
        private String resource;
        private Rule rule;
        private boolean changed;

        private Builder() {
        }

        public final Builder from(IStatixUnit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AStatixUnit instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            if (object instanceof IStatixUnit) {
                IStatixUnit instance = (IStatixUnit)object;
                this.resource(instance.resource());
                Optional<Rule> ruleOptional = instance.rule();
                if (ruleOptional.isPresent()) {
                    this.rule(ruleOptional);
                }
                this.changed(instance.changed());
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder changed(boolean changed) {
            this.changed = changed;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public StatixUnit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixUnit(null, this.resource, this.rule, this.changed, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("changed");
            }
            return "Cannot build StatixUnit, some of required attributes are not set " + attributes;
        }
    }
}

