/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import io.usethesource.capsule.Map;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IIncrementalTypeCheckerContext;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.SolverState;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.tracer.SolverTracer;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

public class ProjectTypeChecker<TR extends SolverTracer.IResult<TR>>
extends AbstractTypeChecker<ProjectResult<TR>, TR> {
    private static final ILogger logger = LoggerUtils.logger(ProjectTypeChecker.class);
    private final IStatixProject<TR> project;

    public ProjectTypeChecker(IStatixProject<TR> project, Spec spec, IDebugContext debug, Supplier<SolverTracer<TR>> tracerFactory) {
        this(project, spec, debug, tracerFactory, 0);
    }

    public ProjectTypeChecker(IStatixProject<TR> project, Spec spec, IDebugContext debug, Supplier<SolverTracer<TR>> tracerFactory, int solverFlags) {
        super(spec, debug, tracerFactory, solverFlags);
        this.project = project;
    }

    @Override
    public IFuture<ProjectResult<TR>> run(IIncrementalTypeCheckerContext<Scope, ITerm, ITerm, ProjectResult<TR>, SolverState> context, List<Scope> rootScopes) {
        Scope projectScope = this.makeSharedScope(context, "s_prj");
        IFuture<Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>>> libraryResults = this.runLibraries(context, this.project.libraries(), projectScope);
        IFuture groupResults = this.runGroups(context, this.project.groups(), Arrays.asList(projectScope));
        IFuture unitResults = this.runUnits(context, this.project.units(), Arrays.asList(projectScope));
        context.closeScope(projectScope);
        return context.runIncremental(initialState -> this.runSolver((ITypeCheckerContext<Scope, ITerm, ITerm>)context, this.project.rule(), (Optional<SolverState>)initialState, Arrays.asList(projectScope)), ProjectResult::solveResult, this::patch, (result, ex) -> AggregateFuture.apply(libraryResults, groupResults, unitResults).thenApply(e -> ProjectResult.of(this.project.resource(), projectScope, (Map.Immutable<String, IUnitResult<Scope, ITerm, ITerm, Unit>>)((Map.Immutable)e._1()), (Map.Immutable)e._2(), (Map.Immutable)e._3(), result, ex))).whenComplete((r, __) -> logger.debug("project {}: returned.", context.id()));
    }
}

