/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.arithmetic;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.nabl2.util.TermFormatter;
import mb.statix.arithmetic.ArithExpr;
import mb.statix.solver.Delay;
import org.metaborg.util.functions.Function2;

class BinExpr
implements ArithExpr,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String op;
    private final ArithExpr ae1;
    private final ArithExpr ae2;
    private final Function2<Integer, Integer, Integer> f;

    public BinExpr(String op, ArithExpr ae1, ArithExpr ae2, Function2<Integer, Integer, Integer> f) {
        this.op = op;
        this.ae1 = ae1;
        this.ae2 = ae2;
        this.f = f;
    }

    @Override
    public int eval(IUniDisunifier unifier) throws Delay {
        return this.f.apply(this.ae1.eval(unifier), this.ae2.eval(unifier));
    }

    @Override
    public ArithExpr apply(ISubstitution.Immutable subst) {
        return new BinExpr(this.op, this.ae1.apply(subst), this.ae2.apply(subst), this.f);
    }

    @Override
    public ArithExpr apply(IRenaming subst) {
        return new BinExpr(this.op, this.ae1.apply(subst), this.ae2.apply(subst), this.f);
    }

    @Override
    public String toString(TermFormatter termToString) {
        return String.valueOf(this.ae1.toString(termToString)) + " " + this.op + " " + this.ae2.toString(termToString);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinExpr binExpr = (BinExpr)o;
        return Objects.equals(this.op, binExpr.op) && Objects.equals(this.ae1, binExpr.ae1) && Objects.equals(this.ae2, binExpr.ae2) && Objects.equals(this.f, binExpr.f);
    }

    public int hashCode() {
        return Objects.hash(this.op, this.ae1, this.ae2, this.f);
    }
}

