/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import io.usethesource.capsule.Map;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mb.scopegraph.resolution.RStep;
import mb.scopegraph.resolution.RVar;

public class State<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<RStep<L>> resolutionSteps;
    private final RVar resultVar;
    private final boolean accepting;
    private final Map.Immutable<L, String> transitions;
    private volatile int hashCode;

    public State(Collection<RStep<L>> resolutionSteps, RVar resultVar, boolean accepting, Map.Immutable<L, String> transitions) {
        this.resolutionSteps = Collections.unmodifiableList(new ArrayList<RStep<L>>(resolutionSteps));
        this.resultVar = resultVar;
        this.accepting = accepting;
        this.transitions = transitions;
    }

    public List<RStep<L>> resolutionSteps() {
        return this.resolutionSteps;
    }

    public RVar resultVar() {
        return this.resultVar;
    }

    public boolean isAccepting() {
        return this.accepting;
    }

    @Nullable
    public String transitionStateId(L label) {
        return (String)this.transitions.get(label);
    }

    public String toString() {
        return "StateMachine{resolutionSteps=" + this.resolutionSteps + ", resultVar=" + this.resultVar + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        State other = (State)obj;
        return Objects.equals(this.resolutionSteps, other.resolutionSteps) && Objects.equals(this.resultVar, other.resultVar);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.resolutionSteps, this.resultVar);
        }
        return result;
    }
}

