/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.RExp;
import mb.scopegraph.resolution.RVar;

public class RShadow<L>
implements RExp<L>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final RVar left;
    private final RVar right;

    public RShadow(RVar left, RVar right) {
        this.left = left;
        this.right = right;
    }

    public RVar left() {
        return this.left;
    }

    public RVar right() {
        return this.right;
    }

    @Override
    public <R> R match(RExp.Cases<L, R> cases) {
        return cases.caseShadow(this.left, this.right);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(RExp.ResolutionCases<L, R> cases) throws ResolutionException, InterruptedException {
        return cases.caseShadow(this.left, this.right);
    }

    public String toString() {
        return "shadow(" + this.left + ", " + this.right + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RShadow other = (RShadow)obj;
        return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

