/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.relations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.scopegraph.relations.ARelationDescription;

public final class RelationDescription
extends ARelationDescription
implements Serializable {
    private final ARelationDescription.Reflexivity reflexivity;
    private final ARelationDescription.Symmetry symmetry;
    private final ARelationDescription.Transitivity transitivity;
    private transient int hashCode;
    private static final long serialVersionUID = 42L;

    private RelationDescription(ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        this.reflexivity = Objects.requireNonNull(reflexivity, "reflexivity");
        this.symmetry = Objects.requireNonNull(symmetry, "symmetry");
        this.transitivity = Objects.requireNonNull(transitivity, "transitivity");
    }

    private RelationDescription(RelationDescription original, ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        this.reflexivity = reflexivity;
        this.symmetry = symmetry;
        this.transitivity = transitivity;
    }

    @Override
    public ARelationDescription.Reflexivity getReflexivity() {
        return this.reflexivity;
    }

    @Override
    public ARelationDescription.Symmetry getSymmetry() {
        return this.symmetry;
    }

    @Override
    public ARelationDescription.Transitivity getTransitivity() {
        return this.transitivity;
    }

    public final RelationDescription withReflexivity(ARelationDescription.Reflexivity value) {
        ARelationDescription.Reflexivity newValue = Objects.requireNonNull(value, "reflexivity");
        if (this.reflexivity == newValue) {
            return this;
        }
        return new RelationDescription(this, newValue, this.symmetry, this.transitivity);
    }

    public final RelationDescription withSymmetry(ARelationDescription.Symmetry value) {
        ARelationDescription.Symmetry newValue = Objects.requireNonNull(value, "symmetry");
        if (this.symmetry == newValue) {
            return this;
        }
        return new RelationDescription(this, this.reflexivity, newValue, this.transitivity);
    }

    public final RelationDescription withTransitivity(ARelationDescription.Transitivity value) {
        ARelationDescription.Transitivity newValue = Objects.requireNonNull(value, "transitivity");
        if (this.transitivity == newValue) {
            return this;
        }
        return new RelationDescription(this, this.reflexivity, this.symmetry, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RelationDescription && this.equalTo(0, (RelationDescription)another);
    }

    private boolean equalTo(int synthetic, RelationDescription another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.reflexivity.equals((Object)another.reflexivity) && this.symmetry.equals((Object)another.symmetry) && this.transitivity.equals((Object)another.transitivity);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.reflexivity.hashCode();
        h += (h << 5) + this.symmetry.hashCode();
        h += (h << 5) + this.transitivity.hashCode();
        return h;
    }

    public static RelationDescription of(ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity) {
        return new RelationDescription(reflexivity, symmetry, transitivity);
    }

    public static RelationDescription copyOf(ARelationDescription instance) {
        if (instance instanceof RelationDescription) {
            return (RelationDescription)instance;
        }
        return RelationDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ RelationDescription(RelationDescription relationDescription, ARelationDescription.Reflexivity reflexivity, ARelationDescription.Symmetry symmetry, ARelationDescription.Transitivity transitivity, RelationDescription relationDescription2) {
        this(relationDescription, reflexivity, symmetry, transitivity);
    }

    public static final class Builder {
        private static final long INIT_BIT_REFLEXIVITY = 1L;
        private static final long INIT_BIT_SYMMETRY = 2L;
        private static final long INIT_BIT_TRANSITIVITY = 4L;
        private long initBits = 7L;
        private ARelationDescription.Reflexivity reflexivity;
        private ARelationDescription.Symmetry symmetry;
        private ARelationDescription.Transitivity transitivity;

        private Builder() {
        }

        public final Builder from(ARelationDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.reflexivity(instance.getReflexivity());
            this.symmetry(instance.getSymmetry());
            this.transitivity(instance.getTransitivity());
            return this;
        }

        public final Builder reflexivity(ARelationDescription.Reflexivity reflexivity) {
            this.reflexivity = Objects.requireNonNull(reflexivity, "reflexivity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder symmetry(ARelationDescription.Symmetry symmetry) {
            this.symmetry = Objects.requireNonNull(symmetry, "symmetry");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder transitivity(ARelationDescription.Transitivity transitivity) {
            this.transitivity = Objects.requireNonNull(transitivity, "transitivity");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public RelationDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RelationDescription(null, this.reflexivity, this.symmetry, this.transitivity, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reflexivity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("symmetry");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transitivity");
            }
            return "Cannot build RelationDescription, some of required attributes are not set " + attributes;
        }
    }
}

