/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.ALabel;
import org.metaborg.util.collection.ImList;

public final class Label
extends ALabel
implements Serializable {
    private final IAttachments attachments;
    private final String name;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long OP_LAZY_INIT_BIT = 1L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 2L;
    private transient ImList.Immutable<ITerm> args;
    private static final long serialVersionUID = 42L;

    private Label(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private Label(IAttachments attachments, String name) {
        this.attachments = attachments;
        this.name = name;
        this.hashCode = super.hashCode();
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final Label withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return Label.validate(new Label(newValue, this.name));
    }

    public final Label withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return Label.validate(new Label(this.attachments, newValue));
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Label label = this;
            synchronized (label) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImList.Immutable<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Label label = this;
            synchronized (label) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.args;
    }

    public static Label of(String name) {
        return Label.validate(new Label(name));
    }

    private static Label validate(Label instance) {
        instance = (Label)instance.check();
        return instance;
    }

    public static Label copyOf(ALabel instance) {
        if (instance instanceof Label) {
            return (Label)instance;
        }
        return Label.of(instance.getName()).withAttachments(instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return Label.validate(new Label(this.attachments, this.name));
    }
}

