/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.bottomup;

import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import io.usethesource.capsule.util.stream.CapsuleCollectors;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.util.graph.alg.incscc.IncSCCAlg;
import mb.nabl2.util.graph.graphimpl.Graph;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IResolutionParameters;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.StuckException;
import mb.scopegraph.pepm16.bottomup.BUCache;
import mb.scopegraph.pepm16.bottomup.BUChanges;
import mb.scopegraph.pepm16.bottomup.BUEnv;
import mb.scopegraph.pepm16.bottomup.BUEnvKey;
import mb.scopegraph.pepm16.bottomup.BUEnvKind;
import mb.scopegraph.pepm16.bottomup.BULabelOrder;
import mb.scopegraph.pepm16.bottomup.BUPathKey;
import mb.scopegraph.pepm16.bottomup.BUPathSet;
import mb.scopegraph.pepm16.bottomup.BUStuckException;
import mb.scopegraph.pepm16.bottomup.InterruptibleRunnable;
import mb.scopegraph.pepm16.esop15.CriticalEdge;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.path.IResolutionPath;
import mb.scopegraph.pepm16.path.IStep;
import mb.scopegraph.pepm16.terms.SpacedName;
import mb.scopegraph.pepm16.terms.path.Paths;
import mb.scopegraph.regexp.IRegExp;
import mb.scopegraph.regexp.IRegExpMatcher;
import mb.scopegraph.regexp.RegExpMatcher;
import mb.scopegraph.relations.RelationDescription;
import mb.scopegraph.relations.impl.Relation;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.collection.HashTrieRelation2;
import org.metaborg.util.collection.HashTrieRelation3;
import org.metaborg.util.collection.IRelation2;
import org.metaborg.util.collection.IRelation3;
import org.metaborg.util.collection.ImList;
import org.metaborg.util.collection.MultiSet;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.stream.StreamUtil;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.tuple.Tuple3;

public class BUNameResolution<S extends IScope, L extends ILabel, O extends IOccurrence>
implements IEsopNameResolution<S, L, O> {
    private static final ILogger logger = LoggerUtils.logger(BUNameResolution.class);
    private final IResolutionParameters<L> params;
    private final IEsopScopeGraph<S, L, O, ?> scopeGraph;
    private final L dataLabel;
    private final Iterable<L> edgeLabels;
    private final IRegExpMatcher<L> wf;
    private final Map.Immutable<BUEnvKind, BULabelOrder<L>> orders;
    private final Predicate2<S, L> isClosed;
    private final HashMap<S, Collection<O>> visibles = new HashMap();
    private final HashMap<S, Collection<O>> reachables = new HashMap();
    private final Map.Transient<Tuple3<BUEnvKind, S, IRegExp<L>>, BUEnvKey<S, L>> envKeys = CapsuleUtil.transientMap();
    private final Map.Transient<Tuple2<SpacedName, L>, BUPathKey<L>> pathKeys = CapsuleUtil.transientMap();
    private final Map.Transient<BUEnvKey<S, L>, BUEnv<S, L, O, IDeclPath<S, L, O>>> envs = CapsuleUtil.transientMap();
    private final Set.Transient<BUEnvKey<S, L>> completed = CapsuleUtil.transientSet();
    private final IRelation2.Transient<BUEnvKey<S, L>, CriticalEdge> openEdges = HashTrieRelation2.Transient.of();
    private final IRelation3.Transient<BUEnvKey<S, L>, IStep<S, L, O>, BUEnvKey<S, L>> backedges = HashTrieRelation3.Transient.of();
    private final IRelation3.Transient<BUEnvKey<S, L>, Tuple3<L, O, IRegExpMatcher<L>>, BUEnvKey<S, L>> backimports = HashTrieRelation3.Transient.of();
    private final Deque<InterruptibleRunnable> worklist = new ArrayDeque<InterruptibleRunnable>();
    private final MultiSet.Transient<BUEnvKey<S, L>> pendingChanges = MultiSet.Transient.of();
    private final Graph<BUEnvKey<S, L>> depGraph = new Graph();
    private final IncSCCAlg<BUEnvKey<S, L>> sccGraph = new IncSCCAlg<BUEnvKey<S, L>>(this.depGraph);

    public BUNameResolution(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isClosed) {
        this.params = params;
        this.scopeGraph = scopeGraph;
        this.edgeLabels = this.params.getLabels();
        this.dataLabel = this.params.getLabelD();
        this.wf = RegExpMatcher.create(params.getPathWf());
        Relation.Immutable noOrder = Relation.Immutable.of(RelationDescription.STRICT_PARTIAL_ORDER);
        this.orders = Map.Immutable.of((Object)((Object)BUEnvKind.VISIBLE), new BULabelOrder<L>(params.getSpecificityOrder()), (Object)((Object)BUEnvKind.REACHABLE), new BULabelOrder(noOrder));
        this.isClosed = isClosed;
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> BUNameResolution<S, L, O> of(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isClosed, IEsopNameResolution.IResolutionCache<S, L, O> cache) {
        BUNameResolution<S, L, O> nr = new BUNameResolution<S, L, O>(params, scopeGraph, isClosed);
        if (cache instanceof BUCache) {
            BUCache _cache = (BUCache)cache;
            nr.envKeys.__putAll(_cache.envKeys);
            nr.pathKeys.__putAll(_cache.pathKeys);
            _cache.envs.forEach((env, ps) -> {
                Object object = bUNameResolution.envs.__put(env, new BUEnv((BULabelOrder)bUNameResolution.orders.get((Object)env.kind), ps));
            });
            nr.envs.keySet().forEach(e -> bUNameResolution.depGraph.insertNode((BUEnvKey)e));
            nr.completed.__insertAll(_cache.completed);
            nr.backedges.putAll(_cache.backedges);
            nr.backedges.stream().forEach(be -> bUNameResolution.depGraph.insertEdge((BUEnvKey)be._3(), (BUEnvKey)be._1()));
            nr.backimports.putAll(_cache.backimports);
            nr.backimports.stream().forEach(be -> bUNameResolution.depGraph.insertEdge((BUEnvKey)be._3(), (BUEnvKey)be._1()));
            nr.openEdges.putAll(_cache.openEdges);
        }
        return nr;
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence> BUNameResolution<S, L, O> of(IResolutionParameters<L> params, IEsopScopeGraph<S, L, O, ?> scopeGraph, Predicate2<S, L> isClosed) {
        return new BUNameResolution<S, L, O>(params, scopeGraph, isClosed);
    }

    @Override
    public Set<O> getResolvedRefs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IResolutionPath<S, L, O>> resolve(O ref, ICancel cancel, IProgress progress) throws InterruptedException, CriticalEdgeException, StuckException {
        return this.resolveRef(ref, cancel);
    }

    @Override
    public Collection<O> decls(S scope) {
        return this.scopeGraph.getDecls().inverse().get(scope);
    }

    @Override
    public Collection<O> refs(S scope) {
        return this.scopeGraph.getRefs().inverse().get(scope);
    }

    @Override
    public Collection<O> visible(S scope, ICancel cancel, IProgress progress) throws InterruptedException, CriticalEdgeException, StuckException {
        Collection<O> decls = this.visibles.get(scope);
        if (decls == null) {
            decls = Paths.declPathsToDecls(this.visibleEnv(scope, cancel));
            this.visibles.put(scope, decls);
        }
        return decls;
    }

    @Override
    public Collection<O> reachable(S scope, ICancel cancel, IProgress progress) throws InterruptedException, CriticalEdgeException, StuckException {
        Collection<O> decls = this.reachables.get(scope);
        if (decls == null) {
            decls = Paths.declPathsToDecls(this.reachableEnv(scope, cancel));
            this.reachables.put(scope, decls);
        }
        return decls;
    }

    @Override
    public Collection<Map.Entry<O, Collection<IResolutionPath<S, L, O>>>> resolutionEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addCached(IEsopNameResolution.IResolutionCache<S, L, O> cache) {
        return false;
    }

    @Override
    public IEsopNameResolution.IResolutionCache<S, L, O> toCache() {
        return new BUCache<S, L, O>(this.envKeys, this.pathKeys, this.envs, this.completed, this.backedges, this.backimports, this.openEdges);
    }

    private Collection<IResolutionPath<S, L, O>> resolveRef(O ref, ICancel cancel) throws InterruptedException, CriticalEdgeException, StuckException {
        IScope scope = this.scopeGraph.getRefs().get(ref).orElse(null);
        if (scope == null) {
            return CapsuleUtil.immutableSet();
        }
        BUEnvKey<IScope, L> key = this.envKey(BUEnvKind.VISIBLE, scope, this.wf);
        BUEnv<IScope, L, O, IDeclPath<IScope, L, O>> env = this.getOrCompute(key, cancel);
        return (Collection)StreamUtil.filterMap(env.pathSet().paths(ref.getSpacedName()).stream(), p -> Paths.resolve(ref, p)).collect(CapsuleCollectors.toSet());
    }

    private Collection<IDeclPath<S, L, O>> visibleEnv(S scope, ICancel cancel) throws InterruptedException, CriticalEdgeException, StuckException {
        BUEnvKey<S, L> key = this.envKey(BUEnvKind.VISIBLE, scope, this.wf);
        return this.getOrCompute(key, cancel).pathSet().paths();
    }

    private Collection<IDeclPath<S, L, O>> reachableEnv(S scope, ICancel cancel) throws InterruptedException, CriticalEdgeException, StuckException {
        BUEnvKey<S, L> key = this.envKey(BUEnvKind.REACHABLE, scope, this.wf);
        return this.getOrCompute(key, cancel).pathSet().paths();
    }

    private BUEnv<S, L, O, IDeclPath<S, L, O>> getOrCompute(BUEnvKey<S, L> env, ICancel cancel) throws InterruptedException, CriticalEdgeException, StuckException {
        BUEnv<S, L, O, IDeclPath<S, L, O>> _env = this.init(env);
        this.work(cancel);
        this.throwIfIncomplete(env);
        return _env;
    }

    @Override
    public void update(Iterable<CriticalEdge> criticalEdges, ICancel cancel, IProgress progress) throws InterruptedException {
        for (CriticalEdge ce : criticalEdges) {
            if (!this.isClosed(ce.scope(), ce.label())) continue;
            for (BUEnvKey<S, L> env : this.openEdges.removeValue(ce)) {
                BUPathSet.Transient declPaths = BUPathSet.Transient.of();
                if (ce.label().equals(this.dataLabel)) {
                    this.initData(env, declPaths);
                } else {
                    this.initEdge(env, ce.label(), env.wf.match(ce.label()));
                }
                this.queueChanges(env, new BUChanges(declPaths.freeze(), BUPathSet.Immutable.of()));
            }
        }
        this.work(cancel);
    }

    private void work(ICancel cancel) throws InterruptedException {
        while (!this.worklist.isEmpty()) {
            cancel.throwIfCancelled();
            this.worklist.pop().run(cancel);
        }
    }

    private BUEnv<S, L, O, IDeclPath<S, L, O>> init(BUEnvKey<S, L> env) {
        BUEnv _env = (BUEnv)this.envs.get(env);
        if (_env != null) {
            return _env;
        }
        logger.trace("init {}", env);
        _env = new BUEnv((BULabelOrder)this.orders.get((Object)env.kind));
        this.envs.__put(env, _env);
        this.depGraph.insertNode(env);
        BUPathSet.Transient declPaths = BUPathSet.Transient.of();
        if (env.wf.isAccepting()) {
            if (this.isClosed((IScope)env.scope, this.dataLabel)) {
                this.initData(env, declPaths);
            } else {
                this.openEdges.put(env, CriticalEdge.of((IScope)env.scope, this.dataLabel));
            }
        }
        for (ILabel l : this.edgeLabels) {
            IRegExpMatcher<ILabel> nextWf = env.wf.match(l);
            if (nextWf.isEmpty()) continue;
            if (this.isClosed((IScope)env.scope, l)) {
                this.initEdge(env, l, nextWf);
                continue;
            }
            this.openEdges.put(env, CriticalEdge.of((IScope)env.scope, l));
        }
        logger.trace("queued init changes {} added {}", env, declPaths.names());
        this.queueChanges(env, new BUChanges(declPaths.freeze(), BUPathSet.Immutable.of()));
        this.queueCheckComplete(env);
        return _env;
    }

    private void initData(BUEnvKey<S, L> env, BUPathSet.Transient<S, L, O, IDeclPath<S, L, O>> declPaths) {
        logger.trace("init data {}", env);
        for (IOccurrence d : this.scopeGraph.getDecls().inverse().get((IScope)env.scope)) {
            BUPathKey<L> key = this.pathKey(d.getSpacedName(), this.dataLabel);
            declPaths.add(key, Paths.decl(Paths.empty((IScope)env.scope), d));
        }
        logger.trace("inited data {}", env);
    }

    private void initEdge(BUEnvKey<S, L> env, L l, IRegExpMatcher<L> nextWf) {
        logger.trace("init edges {} label {} next wf {}", env, l, nextWf);
        for (IScope scope : this.scopeGraph.getDirectEdges().get((IScope)env.scope, l)) {
            BUEnvKey<IScope, L> srcEnv = this.envKey(env.kind, scope, nextWf);
            this.init(srcEnv);
            this.addBackEdge(srcEnv, Paths.direct((IScope)env.scope, l, (IScope)srcEnv.scope), env);
        }
        for (IOccurrence ref : this.scopeGraph.getImportEdges().get((IScope)env.scope, l)) {
            this.addBackImport(ref, l, nextWf, env);
        }
        logger.trace("inited edge {} next wf {}", env, nextWf);
    }

    private void queueChanges(BUEnvKey<S, L> env, BUChanges<S, L, O, IDeclPath<S, L, O>> changes) {
        if (this.completed.contains(env)) {
            throw new IllegalStateException();
        }
        if (changes.isEmpty()) {
            return;
        }
        this.pendingChanges.add(env);
        this.worklist.add(cancel -> this.processChanges(env, changes));
    }

    private void processChanges(BUEnvKey<S, L> env, BUChanges<S, L, O, IDeclPath<S, L, O>> changes) throws InterruptedException {
        if (this.completed.contains(env)) {
            throw new IllegalStateException();
        }
        this.pendingChanges.remove(env);
        logger.trace("process changes {} added {} removed {}", env, changes.addedPaths(), changes.removedPaths());
        BUEnv _env = (BUEnv)this.envs.get(env);
        _env.apply(changes);
        if (_env.hasChanges() && !this.pendingChanges.contains(env)) {
            BUChanges newChanges = _env.commitChanges();
            for (Map.Entry entry : this.backedges.get(env)) {
                BUEnvKey dstEnv = (BUEnvKey)entry.getValue();
                IStep step = (IStep)entry.getKey();
                BUChanges envChanges = newChanges.flatMap((k, ps) -> {
                    ImList.Mutable newPs = new ImList.Mutable(ps.size());
                    for (IDeclPath p : ps) {
                        (this.params.getPathRelevance() ? Paths.append(step, p) : Optional.of(p)).ifPresent(newPs::add);
                    }
                    return Tuple2.of(this.pathKey(k.name(), step.getLabel()), newPs.freeze());
                });
                logger.trace("queued fwd changes {} to {} added {} removed {}", env, dstEnv, envChanges.addedPaths().paths(), envChanges.removedPaths().paths());
                this.queueChanges(dstEnv, envChanges);
            }
        }
        this.checkComplete(env);
    }

    private void queueCheckComplete(BUEnvKey<S, L> env) {
        if (this.completed.contains(env)) {
            return;
        }
        this.worklist.add(cancel -> this.checkComplete(env));
    }

    private void checkComplete(BUEnvKey<S, L> env) throws InterruptedException {
        if (this.completed.contains(env)) {
            return;
        }
        if (this.isComplete(env)) {
            BUEnvKey dstEnv;
            this.completed.__insert(env);
            BUEnv _env = (BUEnv)this.envs.get(env);
            logger.trace("completed {} {}", env, _env.pathSet());
            for (Map.Entry entry : this.backedges.remove(env).entrySet()) {
                dstEnv = (BUEnvKey)entry.getValue();
                this.depGraph.deleteEdgeThatExists(dstEnv, env);
                this.queueCheckComplete(dstEnv);
            }
            for (Map.Entry entry : this.backimports.remove(env).entrySet()) {
                dstEnv = (BUEnvKey)entry.getValue();
                Tuple3 _st = (Tuple3)entry.getKey();
                this.addImportBackEdges(env, _st, dstEnv);
                this.depGraph.deleteEdgeThatExists(dstEnv, env);
                this.queueCheckComplete(dstEnv);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addBackEdge(BUEnvKey<S, L> srcEnv, IStep<S, L, O> step, BUEnvKey<S, L> dstEnv) {
        logger.trace("add back edge {} {} {}", dstEnv, step, srcEnv);
        if (!this.completed.contains(srcEnv)) {
            if (!this.backedges.put(srcEnv, step, dstEnv)) {
                logger.trace(" * duplicate edge");
                return;
            }
            this.depGraph.insertEdge(dstEnv, srcEnv);
            logger.trace(" * new edge");
        } else {
            logger.trace(" * complete edge");
        }
        BUEnv _env = (BUEnv)this.envs.get(srcEnv);
        BUChanges changes = BUChanges.ofPaths(srcEnv, _env.pathSet()).flatMap((k, ps) -> {
            ImList.Mutable newPs = new ImList.Mutable(ps.size());
            for (IDeclPath p : ps) {
                (this.params.getPathRelevance() ? Paths.append(step, p) : Optional.of(p)).ifPresent(newPs::add);
            }
            return Tuple2.of(this.pathKey(k.name(), step.getLabel()), newPs.freeze());
        });
        logger.trace("queued back changes {} to {} added {} removed {}", srcEnv, dstEnv, changes.addedPaths().paths(), changes.removedPaths().paths());
        this.queueChanges(dstEnv, changes);
        logger.trace("added back edge {} {} {}", dstEnv, step, srcEnv);
    }

    private void addBackImport(O ref, L l, IRegExpMatcher<L> wf, BUEnvKey<S, L> dstEnv) {
        IScope refScope = this.scopeGraph.getRefs().get(ref).orElse(null);
        if (refScope == null) {
            return;
        }
        BUEnvKey<IScope, L> refEnv = this.envKey(BUEnvKind.VISIBLE, refScope, this.wf);
        this.init(refEnv);
        Tuple3<L, O, IRegExpMatcher<L>> _st = Tuple3.of(l, ref, wf);
        logger.trace("add back import {} {} {}", dstEnv, _st, refEnv);
        if (!this.completed.contains(refEnv)) {
            if (this.backimports.put(refEnv, _st, dstEnv)) {
                this.depGraph.insertEdge(dstEnv, refEnv);
                logger.trace(" * new import");
            } else {
                logger.trace(" * duplicate import");
            }
        } else {
            logger.trace(" * complete import");
            this.addImportBackEdges(refEnv, _st, dstEnv);
        }
        logger.trace("added back import {} {} {}", dstEnv, _st, refEnv);
    }

    private void addImportBackEdges(BUEnvKey<S, L> refEnv, Tuple3<L, O, IRegExpMatcher<L>> _st, BUEnvKey<S, L> dstEnv) {
        if (!this.completed.contains(refEnv)) {
            throw new IllegalStateException();
        }
        logger.trace("add import back edges {} {} {}", dstEnv, _st, refEnv);
        ILabel l = (ILabel)_st._1();
        IOccurrence ref = (IOccurrence)_st._2();
        IRegExpMatcher<L> wf = _st._3();
        Collection declPaths = ((BUEnv)this.envs.get(refEnv)).pathSet().paths(ref.getSpacedName());
        logger.trace("import back edges {} decl paths {}", dstEnv, declPaths);
        Set.Immutable resPaths = (Set.Immutable)StreamUtil.filterMap(declPaths.stream(), p -> Paths.resolve(ref, p)).collect(CapsuleCollectors.toSet());
        logger.trace("import back edges {} res paths {}", dstEnv, declPaths);
        logger.trace(" * paths {}", resPaths);
        for (IResolutionPath p2 : resPaths) {
            this.scopeGraph.getExportEdges().get(p2.getDeclaration(), l).forEach(ss -> {
                BUEnvKey<IScope, L> srcEnv = this.envKey(bUEnvKey.kind, ss, wf);
                this.init(srcEnv);
                IStep st = Paths.named((IScope)bUEnvKey.scope, l, p2, (IScope)srcEnv.scope);
                this.addBackEdge(srcEnv, st, dstEnv);
            });
        }
        logger.trace("added import back edges {} {} {}", dstEnv, _st, refEnv);
    }

    private boolean isClosed(S scope, L label) {
        return this.isClosed.test(scope, label) && !this.scopeGraph.isOpen(scope, label);
    }

    private BUEnvKey<S, L> envKey(BUEnvKind kind, S scope, IRegExpMatcher<L> wf) {
        Tuple3<BUEnvKind, S, IRegExp<L>> key = Tuple3.of(kind, scope, wf.regexp());
        BUEnvKey<S, L> result = (BUEnvKey<S, L>)this.envKeys.get(key);
        if (result == null) {
            result = new BUEnvKey<S, L>(kind, scope, wf);
            this.envKeys.__put(key, result);
        }
        return result;
    }

    private BUPathKey<L> pathKey(SpacedName name, L label) {
        Tuple2<SpacedName, L> key = Tuple2.of(name, label);
        BUPathKey<L> result = (BUPathKey<L>)this.pathKeys.get(key);
        if (result == null) {
            result = new BUPathKey<L>(name, label);
            this.pathKeys.__put(key, result);
        }
        return result;
    }

    private boolean isComplete(BUEnvKey<S, L> env) {
        BUEnvKey<S, L> rep = this.sccGraph.getRepresentative(env);
        if (this.sccGraph.hasOutgoingEdges(rep)) {
            return false;
        }
        for (BUEnvKey<S, L> cenv : this.sccGraph.sccs.getPartition(rep)) {
            if (!this.pendingChanges.contains(cenv) && !this.openEdges.containsKey(cenv) && !this.backimports.inverse().contains(cenv)) continue;
            return false;
        }
        return true;
    }

    private void throwIfIncomplete(BUEnvKey<S, L> env) throws StuckException, CriticalEdgeException {
        if (!this.pendingChanges.isEmpty()) {
            throw new IllegalStateException("pending changes should be empty");
        }
        Set<BUEnvKey<S, L>> reachableEnvs = this.sccGraph.getAllReachableTargets(env);
        Set.Transient ces = CapsuleUtil.transientSet();
        ces.__insertAll(this.openEdges.get(env));
        for (BUEnvKey<S, L> reachEnv : reachableEnvs) {
            ces.__insertAll(this.openEdges.get(reachEnv));
        }
        if (!ces.isEmpty()) {
            throw new CriticalEdgeException((Iterable<CriticalEdge>)ces.freeze());
        }
        Set reachableReps = (Set)reachableEnvs.stream().map(this.sccGraph::getRepresentative).collect(CapsuleCollectors.toSet());
        for (BUEnvKey reachRep : reachableReps) {
            if (this.sccGraph.hasOutgoingEdges(reachRep)) continue;
            Set<BUEnvKey> scc = this.sccGraph.sccs.getPartition(reachRep);
            boolean hasImports = false;
            for (BUEnvKey cenv : scc) {
                hasImports |= this.backimports.inverse().contains(cenv);
            }
            if (!hasImports) continue;
            Set.Immutable edges = (Set.Immutable)this.backedges.stream().filter(e -> scc.contains(e._3())).map(e -> Tuple3.of((BUEnvKey)e._3(), ((IStep)e._2()).getLabel(), (BUEnvKey)e._1())).collect(CapsuleCollectors.toSet());
            Set.Immutable imports = (Set.Immutable)this.backimports.stream().filter(e -> scc.contains(e._3())).map(e -> Tuple3.of((BUEnvKey)e._3(), Tuple2.of((ILabel)((Tuple3)e._2())._1(), (IOccurrence)((Tuple3)e._2())._2()), (BUEnvKey)e._1())).collect(CapsuleCollectors.toSet());
            throw new BUStuckException((Set<? extends BUEnvKey>)scc, (Set<? extends Tuple3<? extends BUEnvKey, ?, ? extends BUEnvKey>>)edges, (Set<? extends Tuple3<? extends BUEnvKey, ? extends Tuple2<?, ?>, ? extends BUEnvKey>>)imports);
        }
    }
}

