/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public final class UriEncode {
    private static final BitSet doNotEncodeComponent;
    private static final BitSet doNotEncodeFull;

    public static String encodeFull(String input) {
        return UriEncode.encode(input, doNotEncodeFull);
    }

    public static URI encodeToUri(String input) throws URISyntaxException {
        return new URI(UriEncode.encodeFull(input));
    }

    public static String encodeComponent(String input) {
        return UriEncode.encode(input, doNotEncodeComponent);
    }

    private static String encode(String input, BitSet doNotEncode) {
        StringBuilder filtered = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            byte[] b;
            char c = input.charAt(i);
            if (doNotEncode.get(c)) {
                filtered.append(c);
                continue;
            }
            for (byte value : b = UriEncode.charToBytesUTF(c)) {
                filtered.append('%');
                filtered.append("0123456789ABCDEF".charAt(value >> 4 & 0xF));
                filtered.append("0123456789ABCDEF".charAt(value & 0xF));
            }
        }
        return filtered.toString();
    }

    private static byte[] charToBytesUTF(char c) {
        return new String(new char[]{c}).getBytes(StandardCharsets.UTF_8);
    }

    static {
        int i;
        doNotEncodeComponent = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            doNotEncodeComponent.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            doNotEncodeComponent.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            doNotEncodeComponent.set(i);
        }
        doNotEncodeComponent.set(33);
        for (i = 39; i <= 42; ++i) {
            doNotEncodeComponent.set(i);
        }
        doNotEncodeComponent.set(45);
        doNotEncodeComponent.set(46);
        doNotEncodeComponent.set(95);
        doNotEncodeComponent.set(126);
        doNotEncodeFull = new BitSet(256);
        doNotEncodeFull.or(doNotEncodeComponent);
        doNotEncodeFull.set(47);
        doNotEncodeFull.set(58);
        doNotEncodeFull.set(92);
    }
}

