/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path;

import mb.resource.hierarchical.ResourcePath;
import mb.resource.hierarchical.match.path.PathMatcher;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class StartsWithPathMatcher
implements PathMatcher {
    private final String prefix;

    public StartsWithPathMatcher(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public boolean matches(ResourcePath path, ResourcePath rootDir) {
        String relative = SeparatorUtil.convertCurrentToUnixSeparator(rootDir.relativize(path));
        return relative.startsWith(this.prefix);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartsWithPathMatcher that = (StartsWithPathMatcher)o;
        return this.prefix.equals(that.prefix);
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }

    public String toString() {
        return "starts-with(" + this.prefix + ")";
    }
}

