/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.net.URI;
import mb.resource.DefaultQualifiedResourceKeyString;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRuntimeException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface QualifiedResourceKeyString
extends ResourceKeyString,
Comparable<QualifiedResourceKeyString> {
    public static final String separator = "##";

    public static QualifiedResourceKeyString of(String qualifier, String id) {
        if (qualifier.isEmpty()) {
            throw new ResourceRuntimeException("Cannot create a qualified resource key string, qualifier is empty");
        }
        return new DefaultQualifiedResourceKeyString(qualifier, id);
    }

    public static QualifiedResourceKeyString parse(String keyStr) {
        String[] split = keyStr.split(separator, 2);
        if (split.length < 2) {
            throw new ResourceRuntimeException("Cannot parse '" + keyStr + "' into a qualified resource key string, separator '" + separator + "' is missing");
        }
        String qualifier = split[0];
        if (qualifier.isEmpty()) {
            throw new ResourceRuntimeException("Cannot parse '" + keyStr + "' into a qualified resource key string, qualifier is missing");
        }
        return new DefaultQualifiedResourceKeyString(qualifier, split[1]);
    }

    public static QualifiedResourceKeyString of(URI uri) {
        @Nullable String scheme = uri.getScheme();
        if (scheme == null) {
            throw new ResourceRuntimeException("Cannot convert '" + uri + "' to a qualified resource key string, it has no scheme");
        }
        @Nullable String ssp = uri.getSchemeSpecificPart();
        if (ssp == null) {
            throw new ResourceRuntimeException("Cannot convert '" + uri + "' to a resource key string, it has no scheme-specific part");
        }
        return new DefaultQualifiedResourceKeyString(uri.getScheme(), ssp);
    }

    public static String toString(String qualifier, String id) {
        if (qualifier.isEmpty()) {
            throw new ResourceRuntimeException("Cannot create a qualified resource key string, qualifier is empty");
        }
        return qualifier + separator + id;
    }

    @Override
    public @NonNull String getQualifier();

    @Override
    public String getId();

    default public ResourceKeyString withoutQualifier() {
        return ResourceKeyString.of(this.getId());
    }

    @Override
    public String toString();
}

