/*
 * Decompiled with CFR 0.152.
 */
package mb.resource;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import mb.resource.ReadableResource;
import mb.resource.Resource;
import mb.resource.ResourceKey;
import mb.resource.ResourceKeyString;
import mb.resource.ResourceRegistry;
import mb.resource.ResourceRuntimeException;
import mb.resource.ResourceService;
import mb.resource.WritableResource;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.ResourcePath;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultResourceService
implements ResourceService {
    private final List<ResourceService> ancestors;
    private final ResourceRegistry defaultRegistry;
    private final HashMap<String, ResourceRegistry> registries;

    private DefaultResourceService(List<ResourceService> ancestors, ResourceRegistry defaultRegistry, HashMap<String, ResourceRegistry> registries) {
        this.ancestors = ancestors;
        this.defaultRegistry = defaultRegistry;
        this.registries = registries;
    }

    public DefaultResourceService(List<ResourceService> ancestors, ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries) {
        this(new ArrayList<ResourceService>(ancestors), defaultRegistry, DefaultResourceService.toRegistriesHashMap(defaultRegistry, registries));
    }

    public DefaultResourceService(ResourceService parent, ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries) {
        this(Collections.singletonList(parent), defaultRegistry, DefaultResourceService.toRegistriesHashMap(defaultRegistry, registries));
    }

    public DefaultResourceService(ResourceService parent, ResourceRegistry defaultRegistry, ResourceRegistry ... registries) {
        this(Collections.singletonList(parent), defaultRegistry, DefaultResourceService.toRegistriesHashMap(defaultRegistry, Arrays.asList(registries)));
    }

    public DefaultResourceService(ResourceRegistry defaultRegistry, HashMap<String, ResourceRegistry> registries) {
        this(Collections.emptyList(), defaultRegistry, registries);
    }

    public DefaultResourceService(ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries) {
        this(Collections.emptyList(), defaultRegistry, DefaultResourceService.toRegistriesHashMap(defaultRegistry, registries));
    }

    public DefaultResourceService(ResourceRegistry defaultRegistry, ResourceRegistry ... registries) {
        this(Collections.emptyList(), defaultRegistry, DefaultResourceService.toRegistriesHashMap(defaultRegistry, Arrays.asList(registries)));
    }

    private static HashMap<String, ResourceRegistry> toRegistriesHashMap(ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries) {
        HashMap<String, ResourceRegistry> map = new HashMap<String, ResourceRegistry>();
        for (ResourceRegistry registry : registries) {
            String qualifier = registry.qualifier();
            @Nullable ResourceRegistry existing = map.put(qualifier, registry);
            if (existing == null) continue;
            throw new IllegalArgumentException("Resource registry with qualifier '" + qualifier + "' already exists: " + existing);
        }
        if (!map.containsValue(defaultRegistry)) {
            String qualifier = defaultRegistry.qualifier();
            if (!map.containsKey(qualifier)) {
                map.put(qualifier, defaultRegistry);
            } else {
                throw new IllegalArgumentException("An existing resource registry already exists for qualifier '" + qualifier + "' of the default resource registry, but it is not equal to the default resource registry. Either provide the default resource registry as part of the resource registries list, or ensure it does not have an overlapping qualifier with a different resource registry");
            }
        }
        return map;
    }

    @Override
    public Resource getResource(ResourceKey key) {
        String qualifier = key.getQualifier();
        @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
        if (registry == null) {
            throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
        }
        return registry.getResource(key);
    }

    @Override
    public ReadableResource getReadableResource(ResourceKey key) {
        Resource resource = this.getResource(key);
        if (!(resource instanceof ReadableResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a readable resource");
        }
        return (ReadableResource)resource;
    }

    @Override
    public WritableResource getWritableResource(ResourceKey key) {
        Resource resource = this.getResource(key);
        if (!(resource instanceof WritableResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a writable resource");
        }
        return (WritableResource)resource;
    }

    @Override
    public HierarchicalResource getHierarchicalResource(ResourcePath path) {
        Resource resource = this.getResource(path);
        if (!(resource instanceof HierarchicalResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a hierarchical resource");
        }
        return (HierarchicalResource)resource;
    }

    @Override
    public ResourceKey getResourceKey(ResourceKeyString keyStr) {
        @Nullable String qualifier = keyStr.getQualifier();
        if (qualifier == null) {
            try {
                return this.defaultRegistry.getResourceKey(keyStr);
            }
            catch (ResourceRuntimeException e) {
                throw new ResourceRuntimeException("No qualifier was found in string representation of resource key '" + keyStr + "', nor could a resource key be created by the default resource registry '" + this.defaultRegistry + "'", e);
            }
        }
        @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
        if (registry == null) {
            throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
        }
        return registry.getResourceKey(keyStr);
    }

    @Override
    public ResourcePath getResourcePath(ResourceKeyString pathStr) {
        ResourceKey key = this.getResourceKey(pathStr);
        if (!(key instanceof ResourcePath)) {
            throw new ResourceRuntimeException("Resource key '" + key + "' is not a path");
        }
        return (ResourcePath)key;
    }

    @Override
    public Resource getResource(ResourceKeyString keyStr) {
        @Nullable String qualifier = keyStr.getQualifier();
        if (qualifier == null) {
            try {
                return this.defaultRegistry.getResource(keyStr);
            }
            catch (ResourceRuntimeException e) {
                throw new ResourceRuntimeException("No qualifier was found in string representation of resource key '" + keyStr + "', nor could a resource be created by the default resource registry '" + this.defaultRegistry + "'", e);
            }
        }
        @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
        if (registry == null) {
            throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
        }
        return registry.getResource(keyStr);
    }

    @Override
    public ReadableResource getReadableResource(ResourceKeyString keyStr) {
        Resource resource = this.getResource(keyStr);
        if (!(resource instanceof ReadableResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a readable resource");
        }
        return (ReadableResource)resource;
    }

    @Override
    public WritableResource getWritableResource(ResourceKeyString keyStr) {
        Resource resource = this.getResource(keyStr);
        if (!(resource instanceof WritableResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a writable resource");
        }
        return (WritableResource)resource;
    }

    @Override
    public HierarchicalResource getHierarchicalResource(ResourceKeyString pathStr) {
        Resource resource = this.getResource(pathStr);
        if (!(resource instanceof HierarchicalResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a hierarchical resource");
        }
        return (HierarchicalResource)resource;
    }

    @Override
    public Resource appendOrReplaceWith(HierarchicalResource resource, String keyStrOrPath) {
        ResourceKeyString parsedResourceKey = ResourceKeyString.parse(keyStrOrPath);
        @Nullable String qualifier = parsedResourceKey.getQualifier();
        if (qualifier != null) {
            @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
            if (registry == null) {
                throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
            }
            return registry.getResource(parsedResourceKey);
        }
        return resource.appendOrReplaceWithPath(keyStrOrPath);
    }

    @Override
    public HierarchicalResource appendOrReplaceWithHierarchical(HierarchicalResource resource, String pathStrOrPath) {
        Resource newResource = this.appendOrReplaceWith(resource, pathStrOrPath);
        if (!(newResource instanceof HierarchicalResource)) {
            throw new ResourceRuntimeException("Resource '" + resource + "' is not a hierarchical resource");
        }
        return (HierarchicalResource)newResource;
    }

    @Override
    public @Nullable File toLocalFile(ResourceKey key) {
        String qualifier = key.getQualifier();
        @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
        if (registry == null) {
            throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
        }
        return registry.toLocalFile(key);
    }

    @Override
    public @Nullable File toLocalFile(Resource resource) {
        String qualifier = resource.getKey().getQualifier();
        @Nullable ResourceRegistry registry = this.getResourceRegistry(qualifier);
        if (registry == null) {
            throw new ResourceRuntimeException("No resource registry was found for qualifier '" + qualifier + "'");
        }
        return registry.toLocalFile(resource);
    }

    @Override
    public ResourceRegistry getDefaultResourceRegistry() {
        return this.defaultRegistry;
    }

    @Override
    public @Nullable ResourceRegistry getResourceRegistry(String qualifier) {
        @Nullable ResourceRegistry registry = this.registries.get(qualifier);
        if (registry != null) {
            return registry;
        }
        return this.ancestors.stream().map(ancestor -> ancestor.getResourceRegistry(qualifier)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public DefaultResourceService createChild(ResourceRegistry defaultRegistry, Iterable<ResourceRegistry> registries, Iterable<ResourceService> additionalAncestors) {
        ArrayList<ResourceService> ancestors = new ArrayList<ResourceService>();
        ancestors.add(this);
        additionalAncestors.forEach(ancestors::add);
        return new DefaultResourceService(ancestors, defaultRegistry, registries);
    }
}

