/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api.serde;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import mb.pie.api.serde.ClassLoaderObjectInputStream;
import mb.pie.api.serde.DeserializeRuntimeException;
import mb.pie.api.serde.Serde;
import mb.pie.api.serde.SerializeRuntimeException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JavaSerde
implements Serde {
    private final @Nullable ClassLoader defaultClassLoader;

    public JavaSerde(@Nullable ClassLoader defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public JavaSerde() {
        this(null);
    }

    @Override
    public <T> void serialize(T obj, OutputStream outputStream) {
        this.serializeTypeAndObject(obj, outputStream);
    }

    @Override
    public <T> T deserialize(Class<T> type, InputStream inputStream, @Nullable ClassLoader classLoader) {
        @Nullable Object deserialized = this.deserializeObjectOfUnknownType(inputStream, this.getClassLoader(type, classLoader));
        if (deserialized == null) {
            throw new DeserializeRuntimeException(new NullPointerException("Expected non-nullable deserialized object of type '" + type + "', but got null"));
        }
        return this.cast(type, deserialized);
    }

    @Override
    public <T> void serializeNullable(@Nullable T obj, Class<T> type, OutputStream outputStream) {
        this.serializeTypeAndObject(obj, outputStream);
    }

    @Override
    public <T> @Nullable T deserializeNullable(Class<T> type, InputStream inputStream, @Nullable ClassLoader classLoader) {
        @Nullable Object deserialized = this.deserializeObjectOfUnknownType(inputStream, this.getClassLoader(type, classLoader));
        if (deserialized == null) {
            return null;
        }
        return this.cast(type, deserialized);
    }

    private <T> T cast(Class<T> type, Object deserialized) {
        Class<?> deserializedType = deserialized.getClass();
        if (!type.equals(deserializedType)) {
            throw new DeserializeRuntimeException(new ClassCastException("Expected deserialized object of type '" + type + "', but got object of type '" + deserializedType + "'"));
        }
        return (T)deserialized;
    }

    @Override
    public void serializeTypeAndObject(@Nullable Object obj, OutputStream outputStream) {
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);){
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new SerializeRuntimeException(e);
        }
    }

    @Override
    public @Nullable Object deserializeObjectOfUnknownType(InputStream inputStream, @Nullable ClassLoader classLoader) {
        Object object;
        ClassLoaderObjectInputStream objectInputStream = new ClassLoaderObjectInputStream(this.getClassLoader(classLoader), inputStream);
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new DeserializeRuntimeException(e);
            }
        }
        objectInputStream.close();
        return object;
    }

    private ClassLoader getClassLoader(Class<?> type, @Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        if (this.defaultClassLoader != null) {
            return this.defaultClassLoader;
        }
        return this.getClassLoader(type.getClassLoader());
    }

    private ClassLoader getClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader;
        }
        if (this.defaultClassLoader != null) {
            return this.defaultClassLoader;
        }
        return this.getClass().getClassLoader();
    }
}

