/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.envdiff;

import io.usethesource.capsule.Set;
import java.util.ArrayList;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.p_raffrayi.impl.diff.ScopeDiff;
import mb.p_raffrayi.impl.envdiff.AddedEdge;
import mb.p_raffrayi.impl.envdiff.EnvDiff;
import mb.p_raffrayi.impl.envdiff.EnvDiffBuilder;
import mb.p_raffrayi.impl.envdiff.EnvDiffs;
import mb.p_raffrayi.impl.envdiff.IEnvDiff;
import mb.p_raffrayi.impl.envdiff.IEnvDiffer;
import mb.p_raffrayi.impl.envdiff.IEnvDifferContext;
import mb.p_raffrayi.impl.envdiff.RemovedEdge;
import mb.scopegraph.ecoop21.LabelWf;
import mb.scopegraph.oopsla20.diff.Edge;
import org.metaborg.util.collection.BiMap;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action4;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

public class EnvDiffer<S, L, D>
implements IEnvDiffer<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(EnvDiffer.class);
    private final IDifferOps<S, L, D> differOps;
    private final IEnvDifferContext<S, L, D> context;

    public EnvDiffer(IEnvDifferContext<S, L, D> context, IDifferOps<S, L, D> differOps) {
        this.differOps = differOps;
        this.context = context;
    }

    @Override
    public IFuture<IEnvDiff<S, L, D>> diff(S scope, LabelWf<L> labelWf) {
        return this.diff(scope, CapsuleUtil.immutableSet(scope), labelWf);
    }

    private IFuture<IEnvDiff<S, L, D>> diff(S scope, Set.Immutable<S> seenScopes, LabelWf<L> labelWf) {
        logger.debug("Computing env diff for {} ~ {}.", scope, labelWf);
        if (!this.differOps.ownScope(scope)) {
            logger.debug("{} external", scope);
            return CompletableFuture.completedFuture(EnvDiffs.empty());
        }
        return this.context.match(scope).thenCompose(match_opt -> match_opt.map(currentScope -> {
            logger.debug("{} matched", scope);
            ArrayList<IFuture<ScopeDiff<Object, L, D>>> futures = new ArrayList<IFuture<ScopeDiff<Object, L, D>>>();
            for (Object label : this.context.edgeLabels()) {
                if (!labelWf.step(label).isPresent()) continue;
                futures.add(this.context.scopeDiff(scope, label));
            }
            return AggregateFuture.of(futures).thenCompose(diffs -> {
                ArrayList subEnvFutures = new ArrayList();
                EnvDiffBuilder envDiffBuilder = new EnvDiffBuilder(scope, currentScope);
                for (ScopeDiff diff : diffs) {
                    this.traverseApplicable(diff.addedEdges(), labelWf, seenScopes, (label, target, newSeenScopes, newLabelWf) -> {
                        logger.debug("{} -{}-> {} added", scope, label, target);
                        envDiffBuilder.addChange(AddedEdge.of(target, newLabelWf));
                    });
                    this.traverseApplicable(diff.removedEdges(), labelWf, seenScopes, (label, target, newSeenScopes, newLabelWf) -> {
                        logger.debug("{} -{}-> {} removed", scope, label, target);
                        envDiffBuilder.addChange(RemovedEdge.of(target, newLabelWf));
                    });
                    this.traverseApplicable(diff.matchedEdges(), labelWf, seenScopes, (label, target, newSeenScopes, newLabelWf) -> {
                        logger.debug("{} -{}-> {} matched. Computing difftree step.", scope, label, target);
                        subEnvFutures.add(this.diff((S)target, (Set.Immutable<S>)newSeenScopes, (LabelWf<L>)newLabelWf).thenApply(subDiff -> {
                            envDiffBuilder.addEnvDiff(subDiff);
                            return Unit.unit;
                        }));
                    });
                }
                return AggregateFuture.of(subEnvFutures).thenApply(__ -> {
                    logger.debug("env diff for {} ~ {} complete.", scope, labelWf);
                    IEnvDiff diffTree = envDiffBuilder.build();
                    logger.trace("diff value: {}", diffTree);
                    return diffTree;
                });
            });
        }).orElseGet(() -> {
            logger.debug("{} removed", scope);
            Set.Immutable change = CapsuleUtil.immutableSet(RemovedEdge.of(scope, labelWf));
            return CompletableFuture.completedFuture(EnvDiff.of(BiMap.Immutable.of(), change));
        }));
    }

    private void traverseApplicable(Iterable<Edge<S, L>> edges, LabelWf<L> labelWf, Set.Immutable<S> seenScopes, Action4<L, S, Set.Immutable<S>, LabelWf<L>> action) {
        edges.forEach(edge -> labelWf.step(edge.label).ifPresent(newLabelWf -> {
            Set.Transient newSeenScopes = seenScopes.asTransient();
            if (newSeenScopes.__insert(edge.target)) {
                action.apply(edge.label, edge.target, (Set.Immutable)newSeenScopes.freeze(), (LabelWf)newLabelWf);
            }
        }));
    }
}

