/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.envdiff;

import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.impl.envdiff.AAddedEdge;
import mb.scopegraph.ecoop21.LabelWf;

public final class AddedEdge<S, L, D>
extends AAddedEdge<S, L, D> {
    private final S target;
    private final LabelWf<L> labelWf;
    private transient int hashCode;

    private AddedEdge(S target, LabelWf<L> labelWf) {
        this.target = Objects.requireNonNull(target, "target");
        this.labelWf = Objects.requireNonNull(labelWf, "labelWf");
    }

    private AddedEdge(AddedEdge<S, L, D> original, S target, LabelWf<L> labelWf) {
        this.target = target;
        this.labelWf = labelWf;
    }

    @Override
    public S target() {
        return this.target;
    }

    @Override
    public LabelWf<L> labelWf() {
        return this.labelWf;
    }

    public final AddedEdge<S, L, D> withTarget(S value) {
        if (this.target == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "target");
        return new AddedEdge<S, L, D>(this, newValue, this.labelWf);
    }

    public final AddedEdge<S, L, D> withLabelWf(LabelWf<L> value) {
        if (this.labelWf == value) {
            return this;
        }
        LabelWf<L> newValue = Objects.requireNonNull(value, "labelWf");
        return new AddedEdge<S, L, D>(this, this.target, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AddedEdge && this.equalTo(0, (AddedEdge)another);
    }

    private boolean equalTo(int synthetic, AddedEdge<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.target.equals(another.target) && this.labelWf.equals(another.labelWf);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.target.hashCode();
        h += (h << 5) + this.labelWf.hashCode();
        return h;
    }

    public String toString() {
        return "AddedEdge{target=" + this.target + ", labelWf=" + this.labelWf + "}";
    }

    public static <S, L, D> AddedEdge<S, L, D> of(S target, LabelWf<L> labelWf) {
        return new AddedEdge<S, L, D>(target, labelWf);
    }

    public static <S, L, D> AddedEdge<S, L, D> copyOf(AAddedEdge<S, L, D> instance) {
        if (instance instanceof AddedEdge) {
            return (AddedEdge)instance;
        }
        return AddedEdge.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ AddedEdge(AddedEdge addedEdge, Object object, LabelWf labelWf, AddedEdge addedEdge2) {
        this(addedEdge, object, labelWf);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_TARGET = 1L;
        private static final long INIT_BIT_LABEL_WF = 2L;
        private long initBits = 3L;
        private S target;
        private LabelWf<L> labelWf;

        private Builder() {
        }

        public final Builder<S, L, D> from(AAddedEdge<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.target(instance.target());
            this.labelWf(instance.labelWf());
            return this;
        }

        public final Builder<S, L, D> target(S target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> labelWf(LabelWf<L> labelWf) {
            this.labelWf = Objects.requireNonNull(labelWf, "labelWf");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public AddedEdge<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AddedEdge(null, this.target, this.labelWf, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("target");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("labelWf");
            }
            return "Cannot build AddedEdge, some of required attributes are not set " + attributes;
        }
    }
}

