/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.impl.diff.AScopeDiff;
import mb.scopegraph.oopsla20.diff.Edge;

public final class ScopeDiff<S, L, D>
extends AScopeDiff<S, L, D> {
    private final Set<Edge<S, L>> addedEdges;
    private final Set<Edge<S, L>> matchedEdges;
    private final Set<Edge<S, L>> removedEdges;
    private transient int hashCode;

    private ScopeDiff(Iterable<? extends Edge<S, L>> addedEdges, Iterable<? extends Edge<S, L>> matchedEdges, Iterable<? extends Edge<S, L>> removedEdges) {
        this.addedEdges = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(addedEdges, true, false));
        this.matchedEdges = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(matchedEdges, true, false));
        this.removedEdges = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(removedEdges, true, false));
    }

    private ScopeDiff(ScopeDiff<S, L, D> original, Set<Edge<S, L>> addedEdges, Set<Edge<S, L>> matchedEdges, Set<Edge<S, L>> removedEdges) {
        this.addedEdges = addedEdges;
        this.matchedEdges = matchedEdges;
        this.removedEdges = removedEdges;
    }

    @Override
    public Set<Edge<S, L>> addedEdges() {
        return this.addedEdges;
    }

    @Override
    public Set<Edge<S, L>> matchedEdges() {
        return this.matchedEdges;
    }

    @Override
    public Set<Edge<S, L>> removedEdges() {
        return this.removedEdges;
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withAddedEdges(Edge<S, L> ... elements) {
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(Arrays.asList(elements), true, false));
        return new ScopeDiff<S, L, D>(this, newValue, this.matchedEdges, this.removedEdges);
    }

    public final ScopeDiff<S, L, D> withAddedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.addedEdges == elements) {
            return this;
        }
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(elements, true, false));
        return new ScopeDiff<S, L, D>(this, newValue, this.matchedEdges, this.removedEdges);
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withMatchedEdges(Edge<S, L> ... elements) {
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(Arrays.asList(elements), true, false));
        return new ScopeDiff<S, L, D>(this, this.addedEdges, newValue, this.removedEdges);
    }

    public final ScopeDiff<S, L, D> withMatchedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.matchedEdges == elements) {
            return this;
        }
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(elements, true, false));
        return new ScopeDiff<S, L, D>(this, this.addedEdges, newValue, this.removedEdges);
    }

    @SafeVarargs
    public final ScopeDiff<S, L, D> withRemovedEdges(Edge<S, L> ... elements) {
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(Arrays.asList(elements), true, false));
        return new ScopeDiff<S, L, D>(this, this.addedEdges, this.matchedEdges, newValue);
    }

    public final ScopeDiff<S, L, D> withRemovedEdges(Iterable<? extends Edge<S, L>> elements) {
        if (this.removedEdges == elements) {
            return this;
        }
        Set<Edge<S, L>> newValue = ScopeDiff.createUnmodifiableSet(ScopeDiff.createSafeList(elements, true, false));
        return new ScopeDiff<S, L, D>(this, this.addedEdges, this.matchedEdges, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScopeDiff && this.equalTo(0, (ScopeDiff)another);
    }

    private boolean equalTo(int synthetic, ScopeDiff<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.addedEdges.equals(another.addedEdges) && this.matchedEdges.equals(another.matchedEdges) && this.removedEdges.equals(another.removedEdges);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.addedEdges.hashCode();
        h += (h << 5) + this.matchedEdges.hashCode();
        h += (h << 5) + this.removedEdges.hashCode();
        return h;
    }

    public String toString() {
        return "ScopeDiff{addedEdges=" + this.addedEdges + ", matchedEdges=" + this.matchedEdges + ", removedEdges=" + this.removedEdges + "}";
    }

    public static <S, L, D> ScopeDiff<S, L, D> of(Set<Edge<S, L>> addedEdges, Set<Edge<S, L>> matchedEdges, Set<Edge<S, L>> removedEdges) {
        return ScopeDiff.of(addedEdges, matchedEdges, removedEdges);
    }

    public static <S, L, D> ScopeDiff<S, L, D> of(Iterable<? extends Edge<S, L>> addedEdges, Iterable<? extends Edge<S, L>> matchedEdges, Iterable<? extends Edge<S, L>> removedEdges) {
        return new ScopeDiff<S, L, D>(addedEdges, matchedEdges, removedEdges);
    }

    public static <S, L, D> ScopeDiff<S, L, D> copyOf(AScopeDiff<S, L, D> instance) {
        if (instance instanceof ScopeDiff) {
            return (ScopeDiff)instance;
        }
        return ScopeDiff.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    /* synthetic */ ScopeDiff(ScopeDiff scopeDiff, Set set, Set set2, Set set3, ScopeDiff scopeDiff2) {
        this(scopeDiff, set, set2, set3);
    }

    public static final class Builder<S, L, D> {
        private List<Edge<S, L>> addedEdges = new ArrayList<Edge<S, L>>();
        private List<Edge<S, L>> matchedEdges = new ArrayList<Edge<S, L>>();
        private List<Edge<S, L>> removedEdges = new ArrayList<Edge<S, L>>();

        private Builder() {
        }

        public final Builder<S, L, D> from(AScopeDiff<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllAddedEdges(instance.addedEdges());
            this.addAllMatchedEdges(instance.matchedEdges());
            this.addAllRemovedEdges(instance.removedEdges());
            return this;
        }

        public final Builder<S, L, D> addAddedEdges(Edge<S, L> element) {
            this.addedEdges.add(Objects.requireNonNull(element, "addedEdges element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addAddedEdges(Edge<S, L> ... elements) {
            Edge<S, L>[] edgeArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Edge<S, L> element = edgeArray[n2];
                this.addedEdges.add(Objects.requireNonNull(element, "addedEdges element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D> addedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.addedEdges.clear();
            return this.addAllAddedEdges(elements);
        }

        public final Builder<S, L, D> addAllAddedEdges(Iterable<? extends Edge<S, L>> elements) {
            for (Edge<S, L> element : elements) {
                this.addedEdges.add(Objects.requireNonNull(element, "addedEdges element"));
            }
            return this;
        }

        public final Builder<S, L, D> addMatchedEdges(Edge<S, L> element) {
            this.matchedEdges.add(Objects.requireNonNull(element, "matchedEdges element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addMatchedEdges(Edge<S, L> ... elements) {
            Edge<S, L>[] edgeArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Edge<S, L> element = edgeArray[n2];
                this.matchedEdges.add(Objects.requireNonNull(element, "matchedEdges element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D> matchedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.matchedEdges.clear();
            return this.addAllMatchedEdges(elements);
        }

        public final Builder<S, L, D> addAllMatchedEdges(Iterable<? extends Edge<S, L>> elements) {
            for (Edge<S, L> element : elements) {
                this.matchedEdges.add(Objects.requireNonNull(element, "matchedEdges element"));
            }
            return this;
        }

        public final Builder<S, L, D> addRemovedEdges(Edge<S, L> element) {
            this.removedEdges.add(Objects.requireNonNull(element, "removedEdges element"));
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addRemovedEdges(Edge<S, L> ... elements) {
            Edge<S, L>[] edgeArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Edge<S, L> element = edgeArray[n2];
                this.removedEdges.add(Objects.requireNonNull(element, "removedEdges element"));
                ++n2;
            }
            return this;
        }

        public final Builder<S, L, D> removedEdges(Iterable<? extends Edge<S, L>> elements) {
            this.removedEdges.clear();
            return this.addAllRemovedEdges(elements);
        }

        public final Builder<S, L, D> addAllRemovedEdges(Iterable<? extends Edge<S, L>> elements) {
            for (Edge<S, L> element : elements) {
                this.removedEdges.add(Objects.requireNonNull(element, "removedEdges element"));
            }
            return this;
        }

        public ScopeDiff<S, L, D> build() {
            return new ScopeDiff(null, ScopeDiff.createUnmodifiableSet(this.addedEdges), ScopeDiff.createUnmodifiableSet(this.matchedEdges), ScopeDiff.createUnmodifiableSet(this.removedEdges), null);
        }
    }
}

