/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.confirm;

import io.usethesource.capsule.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.patching.PatchCollection;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action0;
import org.metaborg.util.functions.Action4;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function4;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public abstract class ConfirmResult<S, L, D> {
    private static final ILogger logger = LoggerUtils.logger(ConfirmResult.class);
    private static final Deny DENY = new Deny();
    private static final Confirm EMPTY_CONFIRM = new Confirm(CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), PatchCollection.Immutable.of(), PatchCollection.Immutable.of());

    public abstract <T> T match(Function0<T> var1, Function4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>, T> var2);

    public abstract void visit(Action0 var1, Action4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>> var2);

    public abstract ConfirmResult<S, L, D> add(ConfirmResult<S, L, D> var1);

    abstract ConfirmResult<S, L, D> addToSelf(Set.Immutable<IRecordedQuery<S, L, D>> var1, Set.Immutable<IRecordedQuery<S, L, D>> var2, IPatchCollection.Immutable<S> var3, IPatchCollection.Immutable<S> var4);

    public static <S, L, D> ConfirmResult<S, L, D> deny() {
        return DENY;
    }

    public static <S, L, D> ConfirmResult<S, L, D> confirm(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> patches) {
        return ConfirmResult.confirm(addedQueries, removedQueries, PatchCollection.Immutable.of(), patches);
    }

    public static <S, L, D> ConfirmResult<S, L, D> confirm(IPatchCollection.Immutable<S> patches) {
        return ConfirmResult.confirm(CapsuleUtil.immutableSet(), CapsuleUtil.immutableSet(), PatchCollection.Immutable.of(), patches);
    }

    public static <S, L, D> ConfirmResult<S, L, D> confirm(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> resultPatches, IPatchCollection.Immutable<S> globalPatches) {
        return new Confirm(addedQueries, removedQueries, resultPatches, globalPatches);
    }

    public static <S, L, D> ConfirmResult<S, L, D> confirm() {
        return EMPTY_CONFIRM;
    }

    private static class Confirm<S, L, D>
    extends ConfirmResult<S, L, D> {
        private final Set.Immutable<IRecordedQuery<S, L, D>> addedQueries;
        private final Set.Immutable<IRecordedQuery<S, L, D>> removedQueries;
        private final IPatchCollection.Immutable<S> resultPatches;
        private final IPatchCollection.Immutable<S> globalPatches;

        private Confirm(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> resultPatches, IPatchCollection.Immutable<S> globalPatches) {
            logger.trace("Making new confirm result.");
            logger.trace("* added queries:   {}.", addedQueries);
            logger.trace("* removed queries: {}.", removedQueries);
            logger.trace("* result patches:  {}.", resultPatches);
            logger.trace("* global patches:  {}.", globalPatches);
            this.addedQueries = addedQueries;
            this.removedQueries = removedQueries;
            this.resultPatches = resultPatches;
            this.globalPatches = globalPatches;
        }

        @Override
        public <T> T match(Function0<T> onDeny, Function4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>, T> onConfirm) {
            return onConfirm.apply(this.addedQueries, this.removedQueries, this.resultPatches, this.globalPatches);
        }

        @Override
        public void visit(Action0 onDeny, Action4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>> onConfirm) {
            onConfirm.apply(this.addedQueries, this.removedQueries, this.resultPatches, this.globalPatches);
        }

        @Override
        public ConfirmResult<S, L, D> add(ConfirmResult<S, L, D> other) {
            return other.addToSelf(this.addedQueries, this.removedQueries, this.resultPatches, this.globalPatches);
        }

        @Override
        ConfirmResult<S, L, D> addToSelf(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> resultPatches, IPatchCollection.Immutable<S> globalPatches) {
            if (addedQueries.isEmpty() && removedQueries.isEmpty() && resultPatches.isEmpty() && globalPatches.isEmpty()) {
                return this;
            }
            return new Confirm<S, L, D>(this.addedQueries.__insertAll(addedQueries), this.removedQueries.__insertAll(removedQueries), this.resultPatches.putAll(resultPatches), this.globalPatches.putAll(globalPatches));
        }

        public int hashCode() {
            return 17 + 31 * this.resultPatches.hashCode() + 37 * this.globalPatches.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!obj.getClass().equals(this.getClass())) {
                return false;
            }
            Confirm other = (Confirm)obj;
            return this.resultPatches.equals(other.resultPatches) && this.globalPatches.equals(other.globalPatches);
        }

        public String toString() {
            return "Confirm{resultPatches=" + this.resultPatches + ", globalPatches=" + this.globalPatches + "}";
        }
    }

    private static class Deny<S, L, D>
    extends ConfirmResult<S, L, D> {
        private Deny() {
        }

        @Override
        public <T> T match(Function0<T> onDeny, Function4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>, T> onConfirm) {
            return onDeny.apply();
        }

        @Override
        public void visit(Action0 onDeny, Action4<Set.Immutable<IRecordedQuery<S, L, D>>, Set.Immutable<IRecordedQuery<S, L, D>>, IPatchCollection.Immutable<S>, IPatchCollection.Immutable<S>> onConfirm) {
            onDeny.apply();
        }

        @Override
        public ConfirmResult<S, L, D> add(ConfirmResult<S, L, D> other) {
            return this;
        }

        @Override
        ConfirmResult<S, L, D> addToSelf(Set.Immutable<IRecordedQuery<S, L, D>> addedQueries, Set.Immutable<IRecordedQuery<S, L, D>> removedQueries, IPatchCollection.Immutable<S> resultPatches, IPatchCollection.Immutable<S> globalPatches) {
            return this;
        }

        public int hashCode() {
            return 42;
        }

        public boolean equals(Object obj) {
            return obj == this;
        }

        public String toString() {
            return "Deny{}";
        }
    }
}

