/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public class PriorityBlockingQueueThreadPoolScheduler
implements IActorScheduler {
    private static final ILogger logger = LoggerUtils.logger(PriorityBlockingQueueThreadPoolScheduler.class);
    private static final int PREEMPT_FACTOR = 3;
    private static final int RESCHEDULE_FACTOR = 7;
    private final int parallelism;
    private final PriorityBlockingQueue<Runnable> executorQueue;
    private final ThreadPoolExecutor executor;
    private volatile int maxPriority = 0;

    public PriorityBlockingQueueThreadPoolScheduler(int parallelism) {
        this.parallelism = parallelism;
        this.executorQueue = new PriorityBlockingQueue();
        this.executor = new ThreadPoolExecutor(parallelism, parallelism, 60L, TimeUnit.SECONDS, this.executorQueue);
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public boolean isActive() {
        return this.executor.getActiveCount() != 0 || !this.executor.getQueue().isEmpty();
    }

    @Override
    public void schedule(Runnable runnable, int priority, AtomicReference<Runnable> taskRef) {
        Task task = new Task(runnable, priority);
        this.maxPriority = Math.max(this.maxPriority, priority);
        if (!taskRef.compareAndSet(null, task)) {
            logger.error("Actor {} already scheduled", runnable);
            throw new IllegalStateException("Actor " + runnable + " already scheduled.");
        }
        this.executor.execute(task);
    }

    @Override
    public void reschedule(Runnable oldTask, int newPriority, AtomicReference<Runnable> taskRef) {
        Task task = (Task)oldTask;
        if (task.priority * 7 < newPriority && task.active.compareAndSet(true, false)) {
            this.schedule(task.runnable, newPriority, taskRef);
        }
    }

    @Override
    public boolean preempt(int priority) {
        return priority * 3 < this.maxPriority;
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    private void updateMaxPriority() {
        Task task = (Task)this.executorQueue.peek();
        this.maxPriority = task != null ? task.priority : 0;
    }

    private class Task
    implements Runnable,
    Comparable<Task> {
        private final Runnable runnable;
        private final int priority;
        private final AtomicBoolean active;

        Task(Runnable runnable, int priority) {
            this.runnable = runnable;
            this.priority = priority;
            this.active = new AtomicBoolean(true);
        }

        @Override
        public void run() {
            if (this.active.compareAndSet(true, false)) {
                PriorityBlockingQueueThreadPoolScheduler.this.updateMaxPriority();
                this.runnable.run();
            }
        }

        @Override
        public int compareTo(Task o) {
            return o.priority - this.priority;
        }
    }
}

