/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.actors.impl;

import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Set;
import mb.p_raffrayi.actors.IActor;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.actors.IActorSystem;
import mb.p_raffrayi.actors.TypeTag;
import mb.p_raffrayi.actors.impl.Actor;
import mb.p_raffrayi.actors.impl.ActorException;
import mb.p_raffrayi.actors.impl.ActorSystemState;
import mb.p_raffrayi.actors.impl.IActorContext;
import mb.p_raffrayi.actors.impl.IActorImpl;
import mb.p_raffrayi.actors.impl.IActorInternal;
import mb.p_raffrayi.actors.impl.IActorScheduler;
import mb.p_raffrayi.actors.impl.WorkStealingScheduler;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletable;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

public class ActorSystem
implements IActorSystem,
IActorInternal<Void> {
    private static final String ID_SEP = "/";
    private static final ILogger logger = LoggerUtils.logger(ActorSystem.class);
    private final Object lock = new Object();
    private final Set<IActorInternal<?>> children = new HashSet();
    private final IActorScheduler scheduler;
    private volatile ActorSystemState state;
    private final IActorContext context;
    private final ICompletableFuture<Unit> done;

    public ActorSystem() {
        this(Runtime.getRuntime().availableProcessors());
    }

    public ActorSystem(int parallelism) {
        this(new WorkStealingScheduler(parallelism));
    }

    public ActorSystem(IActorScheduler scheduler) {
        this.scheduler = scheduler;
        this.state = ActorSystemState.RUNNING;
        this.context = new ActorContext();
        this.done = new CompletableFuture<Unit>();
        this.done.whenComplete((r, ex) -> scheduler.shutdownNow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> IActor<T> add(String id, TypeTag<T> type, Function1<IActor<T>, T> supplier) {
        String qid = ID_SEP + this.escapeId(id);
        IActorImpl<T> actor = this.doAdd(this, qid, type);
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.equals((Object)ActorSystemState.RUNNING)) {
                throw new IllegalStateException("Actor system already stopped.");
            }
            this.children.add(actor);
            actor._start(this, supplier);
        }
        return actor;
    }

    private <T> IActorImpl<T> doAdd(IActorInternal<?> parent, String qid, TypeTag<T> type) {
        logger.debug("creating actor {}", qid);
        Actor<T> actor = new Actor<T>(this.context, parent, qid, type);
        logger.debug("created actor {}", qid);
        return actor;
    }

    private String escapeId(String id) {
        StringBuilder sb = new StringBuilder();
        StringCharacterIterator it = new StringCharacterIterator(id);
        while (it.current() != '\uffff') {
            char c = it.current();
            switch (c) {
                case '/': 
                case '\\': {
                    sb.append('\\').append(c);
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            it.next();
        }
        return sb.toString();
    }

    @Override
    public <T> T async(IActorRef<T> receiver) {
        return ((IActorInternal)receiver)._invokeStatic(this);
    }

    @Override
    public IFuture<Unit> stop() {
        this.doStop(null);
        return this.done;
    }

    @Override
    public IFuture<Unit> cancel() {
        this.doStop(new InterruptedException());
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean running() {
        Object object = this.lock;
        synchronized (object) {
            return this.state.equals((Object)ActorSystemState.RUNNING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStop(Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            switch (this.state) {
                case RUNNING: {
                    this.state = ActorSystemState.STOPPING;
                    for (IActorInternal<Void> iActorInternal : this.children) {
                        iActorInternal._stop(this, ex);
                    }
                    break;
                }
                case STOPPING: 
                case STOPPED: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state " + (Object)((Object)this.state));
                }
            }
        }
        this.completeIfDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeIfDone() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.state.equals((Object)ActorSystemState.STOPPING)) {
                return;
            }
            if (!this.children.isEmpty()) {
                return;
            }
            this.done.complete(Unit.unit);
        }
    }

    @Override
    public String id() {
        return this.toString();
    }

    @Override
    public void _start(IActorInternal<?> sender, Function1<IActor<Void>, ? extends Void> supplier) {
        throw new IllegalStateException("Actor system is not started by message.");
    }

    @Override
    public Void _invokeDynamic() {
        throw new IllegalStateException("Actor system has no async interface.");
    }

    @Override
    public Void _invokeStatic(IActorInternal<?> system) {
        throw new IllegalStateException("Actor system has no async interface.");
    }

    @Override
    public void _return(IActorInternal<?> sender, Method method, ICompletable result, Object value, Throwable ex) {
        result.complete(value, ex);
    }

    @Override
    public void _stop(IActorInternal<?> sender, Throwable ex) {
        this.doStop(ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _childStopped(IActorInternal<?> sender, Throwable ex) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.children.remove(sender)) {
                throw new IllegalStateException("Stopped actor " + sender + " is not a top-level actor.");
            }
        }
        Throwable ex2 = ex;
        if (ex2 != null && !(ex2 instanceof InterruptedException)) {
            ex2 = new ActorException("Child " + sender + " of " + this + " failed", ex);
        }
        this.doStop(ex2);
        this.completeIfDone();
    }

    public String toString() {
        return "system:/";
    }

    private class ActorContext
    implements IActorContext {
        private ActorContext() {
        }

        @Override
        public <U> IActorImpl<U> add(IActorInternal<?> self, String id, TypeTag<U> type) {
            String qid = String.valueOf(self.id()) + ActorSystem.ID_SEP + ActorSystem.this.escapeId(id);
            IActorImpl actor = ActorSystem.this.doAdd(self, qid, type);
            return actor;
        }

        public <T> T async(IActorRef<T> receiver) {
            return ((IActorInternal)receiver)._invokeDynamic();
        }

        @Override
        public IActorScheduler scheduler() {
            return ActorSystem.this.scheduler;
        }
    }
}

