/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.graphimpl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import mb.nabl2.util.graph.alg.misc.CollectionsFactory;
import mb.nabl2.util.graph.alg.misc.IMultiLookup;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;
import mb.nabl2.util.graph.igraph.IBiDirectionalGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphObserver;

public class Graph<V>
implements IGraphDataSource<V>,
IBiDirectionalGraphDataSource<V> {
    private IMultiLookup<V, V> outgoingEdges = CollectionsFactory.createMultiLookup();
    private IMultiLookup<V, V> incomingEdges = CollectionsFactory.createMultiLookup();
    private Set<V> nodes = CollectionsFactory.createSet();
    private List<IGraphObserver<V>> observers = CollectionsFactory.createObserverList();

    public void insertEdge(V source, V target) {
        this.outgoingEdges.addPair(source, target);
        this.incomingEdges.addPair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeInserted(source, target);
        }
    }

    public void deleteEdgeIfExists(V source, V target) {
        boolean containedEdge = this.outgoingEdges.lookupOrEmpty(source).containsNonZero(target);
        if (containedEdge) {
            this.deleteEdgeThatExists(source, target);
        }
    }

    public void deleteEdgeThatExists(V source, V target) {
        this.outgoingEdges.removePair(source, target);
        this.incomingEdges.removePair(target, source);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeDeleted(source, target);
        }
    }

    @Deprecated
    public void deleteEdge(V source, V target) {
        this.deleteEdgeIfExists(source, target);
    }

    public void insertNode(V node) {
        if (this.nodes.add(node)) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeInserted(node);
            }
        }
    }

    public void deleteNode(V node) {
        if (this.nodes.remove(node)) {
            IMemoryView<V> outgoingView;
            IMemoryView<V> incomingView = this.incomingEdges.lookup(node);
            if (incomingView != null) {
                for (Map.Entry entry : incomingView.asMap().entrySet()) {
                    int i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.deleteEdgeThatExists(entry.getKey(), node);
                        ++i;
                    }
                }
            }
            if ((outgoingView = this.outgoingEdges.lookup(node)) != null) {
                for (Map.Entry entry : outgoingView.asMap().entrySet()) {
                    int i = 0;
                    while (i < (Integer)entry.getValue()) {
                        this.deleteEdgeThatExists(node, entry.getKey());
                        ++i;
                    }
                }
            }
            for (IGraphObserver<V> go : this.observers) {
                go.nodeDeleted(node);
            }
        }
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.observers.add(go);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.observers.add(0, observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.observers.remove(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.nodes;
    }

    @Override
    public IMemoryView<V> getTargetNodes(V source) {
        return this.outgoingEdges.lookupOrEmpty(source);
    }

    @Override
    public IMemoryView<V> getSourceNodes(V target) {
        return this.incomingEdges.lookupOrEmpty(target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes = ");
        for (V n : this.getAllNodes()) {
            sb.append(n.toString());
            sb.append(" ");
        }
        sb.append(" edges = ");
        for (V source : this.outgoingEdges.distinctKeys()) {
            IMemoryView<V> targets = this.outgoingEdges.lookup(source);
            for (V target : targets.distinctValues()) {
                int count = targets.getCount(target);
                int i = 0;
                while (i < count) {
                    sb.append("(" + source + "," + target + ") ");
                    ++i;
                }
            }
        }
        return sb.toString();
    }
}

