/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.alg.scc;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import mb.nabl2.util.graph.alg.misc.CollectionsFactory;
import mb.nabl2.util.graph.alg.scc.SCCProperty;
import mb.nabl2.util.graph.alg.scc.SCCResult;
import mb.nabl2.util.graph.igraph.IGraphDataSource;

public class SCC<V> {
    public static long sccId = 0L;

    private SCC() {
    }

    public static <V> SCCResult<V> computeSCC(IGraphDataSource<V> g) {
        int index = 0;
        HashSet ret = new HashSet();
        Map<V, SCCProperty> nodeMap = CollectionsFactory.createMap();
        Map targetNodeMap = CollectionsFactory.createMap();
        Map notVisitedMap = CollectionsFactory.createMap();
        Stack<Object> nodeStack = new Stack<Object>();
        Stack sccStack = new Stack();
        boolean sink = false;
        boolean finishedTraversal = true;
        Set<V> allNodes = g.getAllNodes();
        for (V n : allNodes) {
            nodeMap.put(n, new SCCProperty(0, 0));
        }
        for (V n : allNodes) {
            if (((SCCProperty)nodeMap.get(n)).getIndex() != 0) continue;
            nodeStack.push(n);
            while (!nodeStack.isEmpty()) {
                Object currentNode = nodeStack.peek();
                sink = false;
                finishedTraversal = false;
                SCCProperty prop = (SCCProperty)nodeMap.get(currentNode);
                if (((SCCProperty)nodeMap.get(currentNode)).getIndex() == 0) {
                    sccStack.push(currentNode);
                    prop.setIndex(++index);
                    prop.setLowlink(index);
                    notVisitedMap.put(currentNode, new HashSet());
                    if (g.getTargetNodes(currentNode) != null) {
                        Set<V> targets = g.getTargetNodes(currentNode).distinctValues();
                        targetNodeMap.put(currentNode, CollectionsFactory.createSet(targets));
                    }
                }
                if (targetNodeMap.get(currentNode) != null) {
                    if (((Set)targetNodeMap.get(currentNode)).size() == 0) {
                        targetNodeMap.remove(currentNode);
                        nodeStack.pop();
                        for (Object targetNode : g.getTargetNodes(currentNode).distinctValues()) {
                            if (((Set)notVisitedMap.get(currentNode)).contains(targetNode)) {
                                prop.setLowlink(Math.min(prop.getLowlink(), ((SCCProperty)nodeMap.get(targetNode)).getLowlink()));
                                continue;
                            }
                            if (!sccStack.contains(targetNode)) continue;
                            prop.setLowlink(Math.min(prop.getLowlink(), ((SCCProperty)nodeMap.get(targetNode)).getIndex()));
                        }
                        finishedTraversal = true;
                    } else {
                        Object targetNode;
                        targetNode = ((Set)targetNodeMap.get(currentNode)).iterator().next();
                        ((Set)targetNodeMap.get(currentNode)).remove(targetNode);
                        if (((SCCProperty)nodeMap.get(targetNode)).getIndex() == 0) {
                            ((Set)notVisitedMap.get(currentNode)).add(targetNode);
                            nodeStack.add(targetNode);
                        }
                    }
                } else {
                    nodeStack.pop();
                    sink = true;
                }
                if (!sink && !finishedTraversal || prop.getLowlink() != prop.getIndex()) continue;
                HashSet<Object> sc = new HashSet<Object>();
                Object targetNode = null;
                do {
                    targetNode = sccStack.pop();
                    sc.add(targetNode);
                } while (!targetNode.equals(currentNode));
                ret.add(sc);
            }
        }
        return new SCCResult(ret, g);
    }
}

