/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.unification;

import java.math.BigInteger;
import org.metaborg.util.functions.Action0;
import org.metaborg.util.functions.Action1;
import org.metaborg.util.functions.Function0;
import org.metaborg.util.functions.Function1;

public final class TermSize {
    public static final TermSize ZERO = new TermSize(BigInteger.ZERO);
    public static final TermSize ONE = new TermSize(BigInteger.ONE);
    public static final TermSize INF = new TermSize(true);
    private final boolean infinite;
    private final BigInteger size;

    private TermSize(BigInteger size) {
        this.size = size;
        this.infinite = false;
    }

    private TermSize(boolean infinite) {
        this.size = BigInteger.ZERO;
        this.infinite = infinite;
    }

    public TermSize add(TermSize other) {
        return this.infinite || other.infinite ? INF : new TermSize(this.size.add(other.size));
    }

    public void ifInfinite(Action0 a) {
        if (this.infinite) {
            a.apply();
        }
    }

    public void ifFinite(Action1<BigInteger> a) {
        if (!this.infinite) {
            a.apply(this.size);
        }
    }

    public <T> T match(Function1<BigInteger, T> onFinite, Function0<T> onInfinite) {
        return this.infinite ? onInfinite.apply() : onFinite.apply(this.size);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.infinite ? 1231 : 1237);
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TermSize other = (TermSize)obj;
        if (this.infinite != other.infinite) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    public String toString() {
        return this.infinite ? "inf" : this.size.toString();
    }

    public static TermSize of(long i) {
        return new TermSize(BigInteger.valueOf(i));
    }
}

