/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.stratego;

import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mb.nabl2.terms.IApplTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.stratego.ITermIndex;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.stratego.TermOrigin;
import mb.nabl2.terms.stratego.TermPlaceholder;

public final class PlaceholderVarMap {
    private final String resourceName;
    private final HashMap<TermVarWrapper, Placeholder> varToPlhdr = new HashMap();
    private final HashMap<Placeholder, TermVarWrapper> plhdrToVar = new HashMap();

    public PlaceholderVarMap(String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean add(ITermVar termVar, IApplTerm placeholderTerm) {
        Placeholder placeholder = this.toPlaceholder(placeholderTerm);
        Placeholder oldPlaceholder = this.varToPlhdr.put(new TermVarWrapper(termVar), placeholder);
        TermVarWrapper oldTermVar = this.plhdrToVar.put(placeholder, new TermVarWrapper(termVar));
        boolean replacedAnything = false;
        if (oldPlaceholder != null && !oldPlaceholder.equals(placeholder)) {
            this.varToPlhdr.remove(oldTermVar);
            replacedAnything = true;
        }
        if (oldTermVar != null && oldTermVar.termVar.equals(termVar)) {
            this.plhdrToVar.remove(oldPlaceholder);
            replacedAnything = true;
        }
        assert (this.plhdrToVar.size() == this.varToPlhdr.size());
        return !replacedAnything;
    }

    @Nullable
    public ITermVar getVar(IApplTerm placeholderTerm) {
        Placeholder placeholder = this.toPlaceholder(placeholderTerm);
        TermVarWrapper termVarWrapper = this.plhdrToVar.get(placeholder);
        return termVarWrapper != null ? termVarWrapper.termVar : null;
    }

    public Set<ITermVar> getVars() {
        return this.varToPlhdr.keySet().stream().map(w -> ((TermVarWrapper)w).termVar).collect(Collectors.toSet());
    }

    @Nullable
    public Placeholder getPlaceholder(ITermVar varTerm) {
        return this.varToPlhdr.get(new TermVarWrapper(varTerm));
    }

    public boolean hasVarWithName(String name) {
        return this.varToPlhdr.keySet().stream().anyMatch(v -> ((TermVarWrapper)v).termVar.getName().equals(name));
    }

    public ITermVar addPlaceholderMapping(IApplTerm placeholderTerm) {
        ITermVar termVar = this.getVar(placeholderTerm);
        if (termVar == null) {
            String newVarName = this.generateName(placeholderTerm);
            termVar = TermBuild.B.newVar(this.resourceName, newVarName);
            termVar = TermOrigin.copy(placeholderTerm, termVar);
            termVar = TermPlaceholder.of(placeholderTerm.getOp()).put(termVar);
            boolean unique = this.add(termVar, placeholderTerm);
            assert (unique) : "Apparently the added term variable and/or placeholder was not unique.";
        }
        return termVar;
    }

    private Placeholder toPlaceholder(IApplTerm term) {
        return new Placeholder(term, TermIndex.get(term).orElse(null));
    }

    private String generateName(IApplTerm placeholderTerm) {
        String prefix = "$" + placeholderTerm.getOp().substring(0, placeholderTerm.getOp().length() - "-Plhdr".length());
        int index = 0;
        String name = String.valueOf(prefix) + index;
        while (this.hasVarWithName(name)) {
            name = String.valueOf(prefix) + ++index;
        }
        return name;
    }

    public static class Placeholder {
        private final ITerm term;
        @Nullable
        private final ITermIndex termIndex;

        public Placeholder(ITerm term, @Nullable ITermIndex termIndex) {
            this.term = term;
            this.termIndex = termIndex;
        }

        public ITerm getTerm() {
            return this.term;
        }

        public ITermIndex getTermIndex() {
            return this.termIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Placeholder that = (Placeholder)o;
            return this.term.equals(that.term) && Objects.equals(this.termIndex, that.termIndex);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.termIndex);
        }

        public String toString() {
            return this.term + (this.termIndex != null ? "@" + this.termIndex : "");
        }
    }

    private static class TermVarWrapper {
        private final ITermVar termVar;

        private TermVarWrapper(ITermVar termVar) {
            this.termVar = termVar;
        }

        public int hashCode() {
            return this.termVar.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TermVarWrapper)) {
                return false;
            }
            return this.termVar.equals(((TermVarWrapper)obj).termVar, true);
        }

        public String toString() {
            return this.termVar.toString();
        }
    }
}

