/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.spoofax.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.Fresh;
import mb.nabl2.solver.ISolution;
import mb.nabl2.spoofax.analysis.AMultiFinalResult;
import mb.nabl2.terms.ITerm;

public final class MultiFinalResult
extends AMultiFinalResult
implements Serializable {
    private final List<IConstraint> constraints;
    private final ISolution solution;
    private final ITerm customAnalysis;
    private final Fresh.Immutable fresh;
    private static final long serialVersionUID = 42L;

    private MultiFinalResult(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        this.constraints = MultiFinalResult.createUnmodifiableList(false, MultiFinalResult.createSafeList(constraints, true, false));
        this.solution = Objects.requireNonNull(solution, "solution");
        this.customAnalysis = customAnalysis.orElse(null);
        this.fresh = Objects.requireNonNull(fresh, "fresh");
    }

    private MultiFinalResult(MultiFinalResult original, List<IConstraint> constraints, ISolution solution, ITerm customAnalysis, Fresh.Immutable fresh) {
        this.constraints = constraints;
        this.solution = solution;
        this.customAnalysis = customAnalysis;
        this.fresh = fresh;
    }

    @Override
    public List<IConstraint> constraints() {
        return this.constraints;
    }

    @Override
    public ISolution solution() {
        return this.solution;
    }

    @Override
    public Optional<ITerm> customAnalysis() {
        return Optional.ofNullable(this.customAnalysis);
    }

    @Override
    public Fresh.Immutable fresh() {
        return this.fresh;
    }

    public final MultiFinalResult withConstraints(IConstraint ... elements) {
        List<IConstraint> newValue = MultiFinalResult.createUnmodifiableList(false, MultiFinalResult.createSafeList(Arrays.asList(elements), true, false));
        return new MultiFinalResult(this, newValue, this.solution, this.customAnalysis, this.fresh);
    }

    public final MultiFinalResult withConstraints(Iterable<? extends IConstraint> elements) {
        if (this.constraints == elements) {
            return this;
        }
        List<IConstraint> newValue = MultiFinalResult.createUnmodifiableList(false, MultiFinalResult.createSafeList(elements, true, false));
        return new MultiFinalResult(this, newValue, this.solution, this.customAnalysis, this.fresh);
    }

    @Override
    public final MultiFinalResult withSolution(ISolution value) {
        if (this.solution == value) {
            return this;
        }
        ISolution newValue = Objects.requireNonNull(value, "solution");
        return new MultiFinalResult(this, this.constraints, newValue, this.customAnalysis, this.fresh);
    }

    @Override
    public final MultiFinalResult withCustomAnalysis(ITerm value) {
        ITerm newValue = Objects.requireNonNull(value, "customAnalysis");
        if (this.customAnalysis == newValue) {
            return this;
        }
        return new MultiFinalResult(this, this.constraints, this.solution, newValue, this.fresh);
    }

    public final MultiFinalResult withCustomAnalysis(Optional<? extends ITerm> optional) {
        ITerm value = optional.orElse(null);
        if (this.customAnalysis == value) {
            return this;
        }
        return new MultiFinalResult(this, this.constraints, this.solution, value, this.fresh);
    }

    @Override
    public final MultiFinalResult withFresh(Fresh.Immutable value) {
        if (this.fresh == value) {
            return this;
        }
        Fresh.Immutable newValue = Objects.requireNonNull(value, "fresh");
        return new MultiFinalResult(this, this.constraints, this.solution, this.customAnalysis, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MultiFinalResult && this.equalTo(0, (MultiFinalResult)another);
    }

    private boolean equalTo(int synthetic, MultiFinalResult another) {
        return this.constraints.equals(another.constraints) && this.solution.equals(another.solution) && Objects.equals(this.customAnalysis, another.customAnalysis) && this.fresh.equals(another.fresh);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.solution.hashCode();
        h += (h << 5) + Objects.hashCode(this.customAnalysis);
        h += (h << 5) + this.fresh.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MultiFinalResult{");
        builder.append("constraints=").append(this.constraints);
        builder.append(", ");
        builder.append("solution=").append(this.solution);
        if (this.customAnalysis != null) {
            builder.append(", ");
            builder.append("customAnalysis=").append(this.customAnalysis);
        }
        builder.append(", ");
        builder.append("fresh=").append(this.fresh);
        return builder.append("}").toString();
    }

    public static MultiFinalResult of(List<IConstraint> constraints, ISolution solution, Optional<ITerm> customAnalysis, Fresh.Immutable fresh) {
        return MultiFinalResult.of(constraints, solution, customAnalysis, fresh);
    }

    public static MultiFinalResult of(Iterable<? extends IConstraint> constraints, ISolution solution, Optional<? extends ITerm> customAnalysis, Fresh.Immutable fresh) {
        return new MultiFinalResult(constraints, solution, customAnalysis, fresh);
    }

    public static MultiFinalResult copyOf(AMultiFinalResult instance) {
        if (instance instanceof MultiFinalResult) {
            return (MultiFinalResult)instance;
        }
        return MultiFinalResult.of(instance.constraints(), instance.solution(), instance.customAnalysis(), instance.fresh());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

