/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.constraints.IConstraint;
import mb.nabl2.solver.ISolver;
import mb.nabl2.solver.messages.IMessages;
import mb.nabl2.terms.unification.u.IUnifier;

public final class SolveResult
extends ISolver.ASolveResult
implements Serializable {
    private final Set.Immutable<IConstraint> constraints;
    private final IMessages.Immutable messages;
    private final IUnifier.Immutable unifierDiff;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final long serialVersionUID = 42L;

    private SolveResult(Builder builder) {
        if (builder.constraints != null) {
            this.initShim.constraints((Set.Immutable<IConstraint>)builder.constraints);
        }
        if (builder.messages != null) {
            this.initShim.messages(builder.messages);
        }
        if (builder.unifierDiff != null) {
            this.initShim.unifierDiff(builder.unifierDiff);
        }
        this.constraints = this.initShim.constraints();
        this.messages = this.initShim.messages();
        this.unifierDiff = this.initShim.unifierDiff();
        this.initShim = null;
    }

    private SolveResult(Set.Immutable<IConstraint> constraints, IMessages.Immutable messages, IUnifier.Immutable unifierDiff) {
        this.constraints = constraints;
        this.messages = messages;
        this.unifierDiff = unifierDiff;
        this.initShim = null;
    }

    @Override
    public Set.Immutable<IConstraint> constraints() {
        InitShim shim = this.initShim;
        return shim != null ? shim.constraints() : this.constraints;
    }

    @Override
    public IMessages.Immutable messages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.messages() : this.messages;
    }

    @Override
    public IUnifier.Immutable unifierDiff() {
        InitShim shim = this.initShim;
        return shim != null ? shim.unifierDiff() : this.unifierDiff;
    }

    public final SolveResult withConstraints(Set.Immutable<IConstraint> value) {
        if (this.constraints == value) {
            return this;
        }
        Set.Immutable<IConstraint> newValue = Objects.requireNonNull(value, "constraints");
        return new SolveResult(newValue, this.messages, this.unifierDiff);
    }

    public final SolveResult withMessages(IMessages.Immutable value) {
        if (this.messages == value) {
            return this;
        }
        IMessages.Immutable newValue = Objects.requireNonNull(value, "messages");
        return new SolveResult(this.constraints, newValue, this.unifierDiff);
    }

    public final SolveResult withUnifierDiff(IUnifier.Immutable value) {
        if (this.unifierDiff == value) {
            return this;
        }
        IUnifier.Immutable newValue = Objects.requireNonNull(value, "unifierDiff");
        return new SolveResult(this.constraints, this.messages, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SolveResult && this.equalTo(0, (SolveResult)another);
    }

    private boolean equalTo(int synthetic, SolveResult another) {
        return this.constraints.equals(another.constraints) && this.messages.equals(another.messages) && this.unifierDiff.equals(another.unifierDiff);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.constraints.hashCode();
        h += (h << 5) + this.messages.hashCode();
        h += (h << 5) + this.unifierDiff.hashCode();
        return h;
    }

    public String toString() {
        return "SolveResult{constraints=" + this.constraints + ", messages=" + this.messages + ", unifierDiff=" + this.unifierDiff + "}";
    }

    public static SolveResult copyOf(ISolver.ASolveResult instance) {
        if (instance instanceof SolveResult) {
            return (SolveResult)instance;
        }
        return SolveResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ SolveResult(Builder builder, SolveResult solveResult) {
        this(builder);
    }

    public static final class Builder {
        private Set.Immutable<IConstraint> constraints;
        private IMessages.Immutable messages;
        private IUnifier.Immutable unifierDiff;

        private Builder() {
        }

        public final Builder from(ISolver.ASolveResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.constraints(instance.constraints());
            this.messages(instance.messages());
            this.unifierDiff(instance.unifierDiff());
            return this;
        }

        public final Builder constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = Objects.requireNonNull(constraints, "constraints");
            return this;
        }

        public final Builder messages(IMessages.Immutable messages) {
            this.messages = Objects.requireNonNull(messages, "messages");
            return this;
        }

        public final Builder unifierDiff(IUnifier.Immutable unifierDiff) {
            this.unifierDiff = Objects.requireNonNull(unifierDiff, "unifierDiff");
            return this;
        }

        public SolveResult build() {
            return new SolveResult(this, null);
        }
    }

    private final class InitShim {
        private byte constraintsBuildStage = 0;
        private Set.Immutable<IConstraint> constraints;
        private byte messagesBuildStage = 0;
        private IMessages.Immutable messages;
        private byte unifierDiffBuildStage = 0;
        private IUnifier.Immutable unifierDiff;

        private InitShim() {
        }

        Set.Immutable<IConstraint> constraints() {
            if (this.constraintsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.constraintsBuildStage == 0) {
                this.constraintsBuildStage = (byte)-1;
                this.constraints = Objects.requireNonNull(SolveResult.super.constraints(), "constraints");
                this.constraintsBuildStage = 1;
            }
            return this.constraints;
        }

        void constraints(Set.Immutable<IConstraint> constraints) {
            this.constraints = constraints;
            this.constraintsBuildStage = 1;
        }

        IMessages.Immutable messages() {
            if (this.messagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.messagesBuildStage == 0) {
                this.messagesBuildStage = (byte)-1;
                this.messages = Objects.requireNonNull(SolveResult.super.messages(), "messages");
                this.messagesBuildStage = 1;
            }
            return this.messages;
        }

        void messages(IMessages.Immutable messages) {
            this.messages = messages;
            this.messagesBuildStage = 1;
        }

        IUnifier.Immutable unifierDiff() {
            if (this.unifierDiffBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.unifierDiffBuildStage == 0) {
                this.unifierDiffBuildStage = (byte)-1;
                this.unifierDiff = Objects.requireNonNull(SolveResult.super.unifierDiff(), "unifierDiff");
                this.unifierDiffBuildStage = 1;
            }
            return this.unifierDiff;
        }

        void unifierDiff(IUnifier.Immutable unifierDiff) {
            this.unifierDiff = unifierDiff;
            this.unifierDiffBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.constraintsBuildStage == -1) {
                attributes.add("constraints");
            }
            if (this.messagesBuildStage == -1) {
                attributes.add("messages");
            }
            if (this.unifierDiffBuildStage == -1) {
                attributes.add("unifierDiff");
            }
            return "Cannot build SolveResult, attribute initializers form cycle " + attributes;
        }
    }
}

