/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.relations.variants;

import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.relations.terms.RelationName;
import mb.nabl2.relations.variants.Variances;

public final class Covariant
extends Variances.ACovariant
implements Serializable {
    private final RelationName relation;
    private static final long serialVersionUID = 42L;

    private Covariant(RelationName relation) {
        this.relation = Objects.requireNonNull(relation, "relation");
    }

    private Covariant(Covariant original, RelationName relation) {
        this.relation = relation;
    }

    @Override
    public RelationName getRelation() {
        return this.relation;
    }

    public final Covariant withRelation(RelationName value) {
        if (this.relation == value) {
            return this;
        }
        RelationName newValue = Objects.requireNonNull(value, "relation");
        return new Covariant(this, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Covariant && this.equalTo(0, (Covariant)another);
    }

    private boolean equalTo(int synthetic, Covariant another) {
        return this.relation.equals(another.relation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relation.hashCode();
        return h;
    }

    public String toString() {
        return "Covariant{relation=" + this.relation + "}";
    }

    public static Covariant of(RelationName relation) {
        return new Covariant(relation);
    }

    public static Covariant copyOf(Variances.ACovariant instance) {
        if (instance instanceof Covariant) {
            return (Covariant)instance;
        }
        return Covariant.of(instance.getRelation());
    }
}

